/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.InputValidator;
import mekanism.generators.client.gui.GuiFusionReactorInfo;
import mekanism.generators.client.gui.element.GuiFusionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.network.to_server.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorController;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiFusionReactorFuel
extends GuiFusionReactorInfo {
    private GuiTextField injectionRateField;

    public GuiFusionReactorFuel(EmptyTileContainer<TileEntityFusionReactorController> container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget((GuiElement)new GuiEnergyTab((IGuiWrapper)this, () -> {
            FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock();
            return List.of(MekanismLang.STORING.translate(new Object[]{EnergyDisplay.of((IEnergyContainer)multiblock.energyContainer)}), GeneratorsLang.PRODUCING_AMOUNT.translate(new Object[]{EnergyDisplay.of((FloatingLong)multiblock.getPassiveGeneration(false, true))}));
        }));
        this.addRenderableWidget((GuiElement)new GuiGasGauge(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).deuteriumTank, () -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).getGasTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 25, 64));
        this.addRenderableWidget((GuiElement)new GuiGasGauge(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).fuelTank, () -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)this, 79, 50));
        this.addRenderableWidget((GuiElement)new GuiGasGauge(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).tritiumTank, () -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).getGasTanks(null), GaugeType.SMALL, (IGuiWrapper)this, 133, 64));
        this.addRenderableWidget((GuiElement)new GuiProgress(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).isBurning(), ProgressType.SMALL_RIGHT, (IGuiWrapper)this, 47, 76));
        this.addRenderableWidget((GuiElement)new GuiProgress(() -> ((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).isBurning(), ProgressType.SMALL_LEFT, (IGuiWrapper)this, 101, 76));
        this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.HEAT));
        this.addRenderableWidget((GuiElement)new GuiFusionReactorTab((IGuiWrapper)this, (TileEntityFusionReactorController)this.tile, GuiFusionReactorTab.FusionReactorTab.STAT));
        this.injectionRateField = (GuiTextField)this.addRenderableWidget((GuiElement)new GuiTextField((IGuiWrapper)this, 98, 115, 26, 11));
        this.injectionRateField.m_5755_(true);
        this.injectionRateField.setInputValidator(InputValidator.DIGIT);
        this.injectionRateField.setEnterHandler(this::setInjection);
        this.injectionRateField.setMaxLength(2);
    }

    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawCenteredText(matrix, (Component)GeneratorsLang.REACTOR_INJECTION_RATE.translate(new Object[]{((FusionReactorMultiblockData)((TileEntityFusionReactorController)this.tile).getMultiblock()).getInjectionRate()}), 0.0f, this.f_97726_, 35.0f, this.titleTextColor());
        this.drawString(matrix, (Component)GeneratorsLang.REACTOR_EDIT_RATE.translate(new Object[0]), 50, 117, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private void setInjection() {
        if (!this.injectionRateField.getText().isEmpty()) {
            MekanismGenerators.packetHandler().sendToServer(new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.INJECTION_RATE, (BlockEntity)this.tile, (double)Integer.parseInt(this.injectionRateField.getText())));
            this.injectionRateField.setText("");
        }
    }
}

