/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import java.util.function.IntSupplier;
import mekanism.api.MekanismIMC;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IModuleDataProvider;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.lib.Version;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.registries.MekanismGases;
import mekanism.generators.common.GeneratorTags;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorCache;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.content.fission.FissionReactorValidator;
import mekanism.generators.common.content.fusion.FusionReactorCache;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.content.fusion.FusionReactorValidator;
import mekanism.generators.common.content.turbine.TurbineCache;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.content.turbine.TurbineValidator;
import mekanism.generators.common.network.GeneratorsPacketHandler;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.registries.GeneratorsBuilders;
import mekanism.generators.common.registries.GeneratorsContainerTypes;
import mekanism.generators.common.registries.GeneratorsFluids;
import mekanism.generators.common.registries.GeneratorsGases;
import mekanism.generators.common.registries.GeneratorsItems;
import mekanism.generators.common.registries.GeneratorsModules;
import mekanism.generators.common.registries.GeneratorsSounds;
import mekanism.generators.common.registries.GeneratorsTileEntityTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mekanismgenerators")
public class MekanismGenerators
implements IModModule {
    public static final String MODID = "mekanismgenerators";
    public static MekanismGenerators instance;
    public final Version versionNumber;
    private final GeneratorsPacketHandler packetHandler;
    public static final MultiblockManager<TurbineMultiblockData> turbineManager;
    public static final MultiblockManager<FissionReactorMultiblockData> fissionReactorManager;
    public static final MultiblockManager<FusionReactorMultiblockData> fusionReactorManager;

    public MekanismGenerators() {
        instance = this;
        Mekanism.modulesLoaded.add(instance);
        MekanismGeneratorsConfig.registerConfigs(ModLoadingContext.get());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::imcQueue);
        GeneratorsItems.ITEMS.register(modEventBus);
        GeneratorsBlocks.BLOCKS.register(modEventBus);
        GeneratorsFluids.FLUIDS.register(modEventBus);
        GeneratorsSounds.SOUND_EVENTS.register(modEventBus);
        GeneratorsContainerTypes.CONTAINER_TYPES.register(modEventBus);
        GeneratorsTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        GeneratorsGases.GASES.register(modEventBus);
        GeneratorsModules.MODULES.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
        this.packetHandler = new GeneratorsPacketHandler();
    }

    public static GeneratorsPacketHandler packetHandler() {
        return MekanismGenerators.instance.packetHandler;
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ((Gas)MekanismGases.ETHENE.get()).addAttribute((ChemicalAttribute)new GasAttributes.Fuel((IntSupplier)MekanismConfig.general.ETHENE_BURN_TIME, () -> ((FloatingLong)MekanismConfig.general.FROM_H2.get()).add(((FloatingLong)MekanismGeneratorsConfig.generators.bioGeneration.get()).multiply(2L * (long)MekanismConfig.general.ETHENE_BURN_TIME.get()))));
        event.enqueueWork(() -> {
            GeneratorTags.init();
            GeneratorsFluids.FLUIDS.registerBucketDispenserBehavior();
        });
        BuildCommand.register((String)"turbine", (ILangEntry)GeneratorsLang.TURBINE, (StructureBuilder)new GeneratorsBuilders.TurbineBuilder());
        BuildCommand.register((String)"fission", (ILangEntry)GeneratorsLang.FISSION_REACTOR, (StructureBuilder)new GeneratorsBuilders.FissionReactorBuilder());
        BuildCommand.register((String)"fusion", (ILangEntry)GeneratorsLang.FUSION_REACTOR, (StructureBuilder)new GeneratorsBuilders.FusionReactorBuilder());
        this.packetHandler.initialize();
        Mekanism.logger.info("Loaded 'Mekanism Generators' module.");
    }

    private void imcQueue(InterModEnqueueEvent event) {
        MekanismIMC.addMekaSuitHelmetModules((IModuleDataProvider[])new IModuleDataProvider[]{GeneratorsModules.SOLAR_RECHARGING_UNIT});
        MekanismIMC.addMekaSuitPantsModules((IModuleDataProvider[])new IModuleDataProvider[]{GeneratorsModules.GEOTHERMAL_GENERATOR_UNIT});
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    public void resetClient() {
        TurbineMultiblockData.clientRotationMap.clear();
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            MekanismModConfig mekConfig = (MekanismModConfig)config;
            mekConfig.clearCache();
        }
    }

    static {
        turbineManager = new MultiblockManager("industrialTurbine", TurbineCache::new, TurbineValidator::new);
        fissionReactorManager = new MultiblockManager("fissionReactor", FissionReactorCache::new, FissionReactorValidator::new);
        fusionReactorManager = new MultiblockManager("fusionReactor", FusionReactorCache::new, FusionReactorValidator::new);
    }
}

