/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import java.util.List;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class TurbineCache
extends MultiblockCache<TurbineMultiblockData> {
    private TileEntityChemicalTank.GasMode dumpMode = TileEntityChemicalTank.GasMode.IDLE;

    public void merge(MultiblockCache<TurbineMultiblockData> mergeCache, List<ItemStack> rejectedItems) {
        super.merge(mergeCache, rejectedItems);
        this.dumpMode = ((TurbineCache)mergeCache).dumpMode;
    }

    public void apply(TurbineMultiblockData data) {
        super.apply((MultiblockData)data);
        data.dumpMode = this.dumpMode;
    }

    public void sync(TurbineMultiblockData data) {
        super.sync((MultiblockData)data);
        this.dumpMode = data.dumpMode;
    }

    public void load(CompoundTag nbtTags) {
        super.load(nbtTags);
        NBTUtils.setEnumIfPresent((CompoundTag)nbtTags, (String)"dumping", TileEntityChemicalTank.GasMode::byIndexStatic, mode -> {
            this.dumpMode = mode;
        });
    }

    public void save(CompoundTag nbtTags) {
        super.save(nbtTags);
        nbtTags.m_128405_("dumping", this.dumpMode.ordinal());
    }
}

