/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.network.to_server;

import mekanism.api.functions.TriConsumer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorLogicAdapter;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorLogicAdapter;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketGeneratorsGuiInteract
implements IMekanismPacket {
    private final GeneratorsGuiInteraction interaction;
    private final BlockPos tilePosition;
    private final double extra;

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockEntity tile) {
        this(interaction, tile.m_58899_());
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockEntity tile, double extra) {
        this(interaction, tile.m_58899_(), extra);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition) {
        this(interaction, tilePosition, 0.0);
    }

    public PacketGeneratorsGuiInteract(GeneratorsGuiInteraction interaction, BlockPos tilePosition, double extra) {
        this.interaction = interaction;
        this.tilePosition = tilePosition;
        this.extra = extra;
    }

    public void handle(NetworkEvent.Context context) {
        TileEntityMekanism tile;
        ServerPlayer player = context.getSender();
        if (player != null && (tile = (TileEntityMekanism)WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)player.f_19853_, (BlockPos)this.tilePosition)) != null) {
            this.interaction.consume(tile, (Player)player, this.extra);
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.interaction);
        buffer.m_130064_(this.tilePosition);
        buffer.writeDouble(this.extra);
    }

    public static PacketGeneratorsGuiInteract decode(FriendlyByteBuf buffer) {
        return new PacketGeneratorsGuiInteract((GeneratorsGuiInteraction)buffer.m_130066_(GeneratorsGuiInteraction.class), buffer.m_130135_(), buffer.readDouble());
    }

    public static enum GeneratorsGuiInteraction {
        INJECTION_RATE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFusionReactorBlock) {
                TileEntityFusionReactorBlock reactorBlock = (TileEntityFusionReactorBlock)((Object)tile);
                reactorBlock.setInjectionRateFromPacket((int)Math.round(extra));
            } else if (tile instanceof TileEntityFissionReactorCasing) {
                TileEntityFissionReactorCasing reactorCasing = (TileEntityFissionReactorCasing)((Object)tile);
                reactorCasing.setRateLimitFromPacket((double)extra);
            }
        })),
        LOGIC_TYPE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFissionReactorLogicAdapter) {
                TileEntityFissionReactorLogicAdapter logicAdapter = (TileEntityFissionReactorLogicAdapter)tile;
                logicAdapter.setLogicTypeFromPacket(TileEntityFissionReactorLogicAdapter.FissionReactorLogic.byIndexStatic((int)Math.round(extra)));
            } else if (tile instanceof TileEntityFusionReactorLogicAdapter) {
                TileEntityFusionReactorLogicAdapter logicAdapter = (TileEntityFusionReactorLogicAdapter)tile;
                logicAdapter.setLogicTypeFromPacket(TileEntityFusionReactorLogicAdapter.FusionReactorLogic.byIndexStatic((int)Math.round(extra)));
            }
        })),
        FISSION_ACTIVE((TriConsumer<TileEntityMekanism, Player, Double>)((TriConsumer)(tile, player, extra) -> {
            if (tile instanceof TileEntityFissionReactorCasing) {
                TileEntityFissionReactorCasing reactorCasing = (TileEntityFissionReactorCasing)((Object)tile);
                reactorCasing.setReactorActive(Math.round(extra) == 1L);
            }
        }));

        private final TriConsumer<TileEntityMekanism, Player, Double> consumerForTile;

        private GeneratorsGuiInteraction(TriConsumer<TileEntityMekanism, Player, Double> consumerForTile) {
            this.consumerForTile = consumerForTile;
        }

        public void consume(TileEntityMekanism tile, Player player, double extra) {
            this.consumerForTile.accept((Object)tile, (Object)player, (Object)extra);
        }
    }
}

