/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.slot;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NonNull;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.util.MekanismUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidFuelInventorySlot
extends FluidInventorySlot {
    private final Int2ObjectFunction<@NonNull FluidStack> fuelCreator;
    private final ToIntFunction<@NonNull ItemStack> fuelValue;

    public static FluidFuelInventorySlot forFuel(IExtendedFluidTank fluidTank, ToIntFunction<@NonNull ItemStack> fuelValue, Int2ObjectFunction<@NonNull FluidStack> fuelCreator, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(fuelCreator, "Fuel fluid stack creator cannot be null");
        Objects.requireNonNull(fuelValue, "Fuel value calculator cannot be null");
        return new FluidFuelInventorySlot(fluidTank, fuelValue, fuelCreator, stack -> {
            Optional cap = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
            if (cap.isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    if (!fluidTank.isFluidValid(fluidHandlerItem.getFluidInTank(tank))) continue;
                    return false;
                }
            }
            return fuelValue.applyAsInt((ItemStack)stack) == 0;
        }, stack -> {
            Optional cap = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
            if (cap.isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty() || fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    return true;
                }
            }
            return fuelValue.applyAsInt((ItemStack)stack) > 0;
        }, listener, x, y);
    }

    private FluidFuelInventorySlot(IExtendedFluidTank fluidTank, ToIntFunction<@NonNull ItemStack> fuelValue, Int2ObjectFunction<@NonNull FluidStack> fuelCreator, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        super(fluidTank, canExtract, canInsert, alwaysTrue, listener, x, y);
        this.fuelCreator = fuelCreator;
        this.fuelValue = fuelValue;
    }

    public void fillOrBurn() {
        int fuel;
        int needed;
        if (!this.isEmpty() && (needed = this.fluidTank.getNeeded()) > 0 && !this.fillTank() && (fuel = this.fuelValue.applyAsInt(this.current)) > 0 && fuel <= needed) {
            boolean hasContainer = this.current.hasContainerItem();
            if (hasContainer && this.current.m_41613_() > 1) {
                return;
            }
            this.fluidTank.insert((FluidStack)this.fuelCreator.apply(fuel), Action.EXECUTE, AutomationType.INTERNAL);
            if (hasContainer) {
                this.setStack(this.current.getContainerItem());
            } else {
                MekanismUtils.logMismatchedStackSize((long)this.shrinkStack(1, Action.EXECUTE), (long)1L);
            }
        }
    }
}

