/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityFusionReactorLogicAdapter
extends TileEntityFusionReactorBlock
implements IReactorLogic<FusionReactorLogic>,
IHasMode {
    public FusionReactorLogic logicType = FusionReactorLogic.DISABLED;
    private boolean activeCooled;
    private boolean prevOutputting;

    public TileEntityFusionReactorLogicAdapter(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_LOGIC_ADAPTER, pos, state);
    }

    protected boolean onUpdateServer(FusionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        boolean outputting = this.checkMode();
        if (outputting != this.prevOutputting) {
            Level world = this.m_58904_();
            if (world != null) {
                world.m_46672_(this.m_58899_(), this.getBlockType());
            }
            this.prevOutputting = outputting;
        }
        return needsPacket;
    }

    public boolean checkMode() {
        if (this.isRemote()) {
            return this.prevOutputting;
        }
        FusionReactorMultiblockData multiblock = (FusionReactorMultiblockData)this.getMultiblock();
        if (multiblock.isFormed()) {
            return switch (this.logicType) {
                default -> throw new IncompatibleClassChangeError();
                case FusionReactorLogic.READY -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getIgnitionTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case FusionReactorLogic.CAPACITY -> {
                    if (multiblock.getLastPlasmaTemp() >= multiblock.getMaxPlasmaTemperature(this.activeCooled)) {
                        yield true;
                    }
                    yield false;
                }
                case FusionReactorLogic.DEPLETED -> {
                    if (multiblock.deuteriumTank.getStored() < (long)(multiblock.getInjectionRate() / 2) || multiblock.tritiumTank.getStored() < (long)(multiblock.getInjectionRate() / 2)) {
                        yield true;
                    }
                    yield false;
                }
                case FusionReactorLogic.DISABLED -> false;
            };
        }
        return false;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        NBTUtils.setEnumIfPresent((CompoundTag)nbt, (String)"logicType", FusionReactorLogic::byIndexStatic, logicType -> {
            this.logicType = logicType;
        });
        this.activeCooled = nbt.m_128471_("activeCooled");
    }

    public void m_183515_(@Nonnull CompoundTag nbtTags) {
        super.m_183515_(nbtTags);
        nbtTags.m_128405_("logicType", this.logicType.ordinal());
        nbtTags.m_128379_("activeCooled", this.activeCooled);
    }

    @Override
    public boolean canBeMaster() {
        return false;
    }

    public void nextMode() {
        this.activeCooled = !this.activeCooled;
        this.markForSave();
    }

    @ComputerMethod(nameOverride="isActiveCooledLogic")
    public boolean isActiveCooled() {
        return this.activeCooled;
    }

    @Override
    @ComputerMethod(nameOverride="getLogicMode")
    public FusionReactorLogic getMode() {
        return this.logicType;
    }

    public FusionReactorLogic[] getModes() {
        return FusionReactorLogic.values();
    }

    @ComputerMethod(nameOverride="setLogicMode")
    public void setLogicTypeFromPacket(FusionReactorLogic logicType) {
        if (this.logicType != logicType) {
            this.logicType = logicType;
            this.markForSave();
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create(FusionReactorLogic::byIndexStatic, (Enum)FusionReactorLogic.DISABLED, this::getMode, value -> {
            this.logicType = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(this::isActiveCooled, value -> {
            this.activeCooled = value;
        }));
        container.track((ISyncableData)SyncableBoolean.create(() -> this.prevOutputting, value -> {
            this.prevOutputting = value;
        }));
    }

    @ComputerMethod
    private void setActiveCooledLogic(boolean active) {
        if (this.activeCooled != active) {
            this.nextMode();
        }
    }

    public static enum FusionReactorLogic implements IReactorLogicMode<FusionReactorLogic>,
    IHasTranslationKey
    {
        DISABLED(GeneratorsLang.REACTOR_LOGIC_DISABLED, GeneratorsLang.DESCRIPTION_REACTOR_DISABLED, new ItemStack((ItemLike)Items.f_42403_)),
        READY(GeneratorsLang.REACTOR_LOGIC_READY, GeneratorsLang.DESCRIPTION_REACTOR_READY, new ItemStack((ItemLike)Items.f_42451_)),
        CAPACITY(GeneratorsLang.REACTOR_LOGIC_CAPACITY, GeneratorsLang.DESCRIPTION_REACTOR_CAPACITY, new ItemStack((ItemLike)Items.f_42451_)),
        DEPLETED(GeneratorsLang.REACTOR_LOGIC_DEPLETED, GeneratorsLang.DESCRIPTION_REACTOR_DEPLETED, new ItemStack((ItemLike)Items.f_42451_));

        private static final FusionReactorLogic[] MODES;
        private final ILangEntry name;
        private final ILangEntry description;
        private final ItemStack renderStack;

        private FusionReactorLogic(ILangEntry name, ILangEntry description, ItemStack stack) {
            this.name = name;
            this.description = description;
            this.renderStack = stack;
        }

        @Override
        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getTranslationKey() {
            return this.name.getTranslationKey();
        }

        @Override
        public Component getDescription() {
            return this.description.translate(new Object[0]);
        }

        @Override
        public EnumColor getColor() {
            return EnumColor.RED;
        }

        public static FusionReactorLogic byIndexStatic(int index) {
            return (FusionReactorLogic)MathUtils.getByIndexMod((Object[])MODES, (int)index);
        }

        static {
            MODES = FusionReactorLogic.values();
        }
    }
}

