/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.fusion;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigurable;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.content.fusion.FusionReactorMultiblockData;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mekanism.generators.common.tile.fusion.TileEntityFusionReactorBlock;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityFusionReactorPort
extends TileEntityFusionReactorBlock
implements IConfigurable {
    public TileEntityFusionReactorPort(BlockPos pos, BlockState state) {
        super((IBlockProvider)GeneratorsBlocks.FUSION_REACTOR_PORT, pos, state);
        this.delaySupplier = () -> 0;
    }

    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getGasTanks(side);
    }

    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getEnergyContainers(side);
    }

    @Nonnull
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getHeatCapacitors(side);
    }

    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        return side -> ((FusionReactorMultiblockData)this.getMultiblock()).getInventorySlots(side);
    }

    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.GAS || type == SubstanceType.FLUID || type == SubstanceType.ENERGY || type == SubstanceType.HEAT) {
            return false;
        }
        return super.persists(type);
    }

    public boolean persistInventory() {
        return false;
    }

    protected boolean onUpdateServer(FusionReactorMultiblockData multiblock) {
        boolean needsPacket = super.onUpdateServer((MultiblockData)multiblock);
        if (this.getActive() && multiblock.isFormed()) {
            Set directionsToEmit = multiblock.getDirectionsToEmit(this.m_58899_());
            ChemicalUtil.emit((Set)directionsToEmit, (IChemicalTank)multiblock.steamTank, (BlockEntity)this);
            CableUtils.emit((Set)directionsToEmit, (IEnergyContainer)multiblock.energyContainer, (BlockEntity)this);
        }
        return needsPacket;
    }

    @Nullable
    public IHeatHandler getAdjacent(@Nonnull Direction side) {
        BlockEntity adj;
        if (this.canHandleHeat() && this.getHeatCapacitorCount(side) > 0 && !((adj = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), (BlockPos)this.m_58899_().m_142300_(side))) instanceof TileEntityFusionReactorBlock)) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, (Capability)Capabilities.HEAT_HANDLER_CAPABILITY, (Direction)side.m_122424_()).resolve().orElse(null);
        }
        return null;
    }

    public InteractionResult onSneakRightClick(Player player) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.m_6352_(MekanismUtils.logFormat((Object)GeneratorsLang.REACTOR_PORT_EJECT.translate(new Object[]{BooleanStateDisplay.InputOutput.of((boolean)oldMode, (boolean)true)})), Util.f_137441_);
        }
        return InteractionResult.SUCCESS;
    }

    public int getRedstoneLevel() {
        return ((FusionReactorMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }

    public boolean exposesMultiblockToComputer() {
        return false;
    }

    @ComputerMethod
    private boolean getMode() {
        return this.getActive();
    }

    @ComputerMethod
    private void setMode(boolean output) {
        this.setActive(output);
    }
}

