/*
 * Decompiled with CFR 0.152.
 */
package shadows.fastbench.net;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.network.NetworkEvent;
import shadows.fastbench.api.ICraftingContainer;
import shadows.fastbench.api.ICraftingScreen;
import shadows.placebo.network.MessageHelper;
import shadows.placebo.network.MessageProvider;

public class RecipeMessage
implements MessageProvider<RecipeMessage> {
    public static final ResourceLocation NULL = new ResourceLocation("null", "null");
    ResourceLocation recipeId;
    ItemStack output;

    public RecipeMessage() {
    }

    public RecipeMessage(Recipe<CraftingContainer> recipeId, ItemStack output) {
        this.recipeId = recipeId == null ? NULL : recipeId.m_6423_();
        this.output = output;
    }

    public RecipeMessage(ResourceLocation recipeId, ItemStack output) {
        this.recipeId = recipeId;
        this.output = output;
    }

    public Class<RecipeMessage> getMsgClass() {
        return RecipeMessage.class;
    }

    public RecipeMessage read(FriendlyByteBuf buf) {
        ResourceLocation rec;
        return new RecipeMessage(rec, (rec = new ResourceLocation(buf.m_130277_())).equals((Object)NULL) ? ItemStack.f_41583_ : buf.m_130267_());
    }

    public void write(RecipeMessage msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.recipeId.toString());
        if (!msg.recipeId.equals((Object)NULL)) {
            buf.m_130055_(msg.output);
        }
    }

    public void handle(RecipeMessage msg, Supplier<NetworkEvent.Context> ctx) {
        MessageHelper.handlePacket(() -> () -> {
            Recipe recipe = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(msg.recipeId).orElse(null);
            if (Minecraft.m_91087_().f_91080_ instanceof ICraftingScreen) {
                ICraftingContainer c = ((ICraftingScreen)Minecraft.m_91087_().f_91080_).getContainer();
                RecipeMessage.updateLastRecipe(c.getResult(), (Recipe<CraftingContainer>)recipe, msg.output);
            } else if (Minecraft.m_91087_().f_91080_ instanceof InventoryScreen) {
                InventoryMenu c = (InventoryMenu)((InventoryScreen)Minecraft.m_91087_().f_91080_).m_6262_();
                RecipeMessage.updateLastRecipe(c.f_39702_, (Recipe<CraftingContainer>)recipe, msg.output);
            }
        }, ctx);
    }

    public static void updateLastRecipe(ResultContainer craftResult, Recipe<CraftingContainer> rec, ItemStack output) {
        craftResult.m_6029_(rec);
        craftResult.m_6836_(0, output);
    }
}

