/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.connected;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class ConnectedModelRegistry {
    private static final BiPredicate<BlockState, BlockState> BLOCK_CONNECTION_PREDICATE = (s1, s2) -> s1.m_60734_() == s2.m_60734_();
    private static final Map<String, BiPredicate<BlockState, BlockState>> CONNECTION_PREDICATES = new HashMap<String, BiPredicate<BlockState, BlockState>>();
    private static final Map<String, String[]> CONNECTION_TYPES;

    public static void registerPredicate(String name, BiPredicate<BlockState, BlockState> predicate) {
        CONNECTION_PREDICATES.putIfAbsent(name, predicate);
    }

    public static BiPredicate<BlockState, BlockState> deserializePredicate(JsonObject json, String key) {
        String name = GsonHelper.m_13851_((JsonObject)json, (String)key, (String)"block");
        if (!CONNECTION_PREDICATES.containsKey(name)) {
            throw new JsonSyntaxException("Unknown connection predicate " + name);
        }
        return CONNECTION_PREDICATES.get(name);
    }

    public static BiPredicate<BlockState, BlockState> getPredicate(String name) {
        return CONNECTION_PREDICATES.getOrDefault(name, BLOCK_CONNECTION_PREDICATE);
    }

    private static boolean safeGet(BlockState state, BooleanProperty prop) {
        return state.m_61138_((Property)prop) && (Boolean)state.m_61143_((Property)prop) != false;
    }

    public static void registerType(String name, Function<Predicate<Direction>, String> mapper) {
        if (!CONNECTION_TYPES.containsKey(name)) {
            String[] suffixes = new String[16];
            for (int i = 0; i < 16; ++i) {
                int index = i;
                suffixes[i] = mapper.apply(dir -> {
                    int flag = 1 << dir.m_122416_();
                    return (index & flag) == flag;
                });
            }
            CONNECTION_TYPES.put(name, suffixes);
        }
    }

    public static String[] deserializeType(JsonElement json, String key) {
        String name = GsonHelper.m_13805_((JsonElement)json, (String)key);
        if (!CONNECTION_TYPES.containsKey(name)) {
            throw new JsonSyntaxException("Unknown connection type " + name);
        }
        return CONNECTION_TYPES.get(name);
    }

    static {
        ConnectedModelRegistry.registerPredicate("block", BLOCK_CONNECTION_PREDICATE);
        ConnectedModelRegistry.registerPredicate("pane", (state, neighbor) -> state.m_60734_() == neighbor.m_60734_() && (ConnectedModelRegistry.safeGet(state, PipeBlock.f_55148_) || ConnectedModelRegistry.safeGet(state, PipeBlock.f_55149_) || ConnectedModelRegistry.safeGet(state, PipeBlock.f_55150_) || ConnectedModelRegistry.safeGet(state, PipeBlock.f_55151_)) == (ConnectedModelRegistry.safeGet(neighbor, PipeBlock.f_55148_) || ConnectedModelRegistry.safeGet(neighbor, PipeBlock.f_55149_) || ConnectedModelRegistry.safeGet(neighbor, PipeBlock.f_55150_) || ConnectedModelRegistry.safeGet(neighbor, PipeBlock.f_55151_)));
        CONNECTION_TYPES = new HashMap<String, String[]>();
        ConnectedModelRegistry.registerType("cornerless_full", predicate -> {
            Object name = "";
            if (predicate.test(Direction.NORTH)) {
                name = (String)name + "u";
            }
            if (predicate.test(Direction.SOUTH)) {
                name = (String)name + "d";
            }
            if (predicate.test(Direction.WEST)) {
                name = (String)name + "l";
            }
            if (predicate.test(Direction.EAST)) {
                name = (String)name + "r";
            }
            return name;
        });
        ConnectedModelRegistry.registerType("horizontal", predicate -> {
            boolean right = predicate.test(Direction.EAST);
            if (predicate.test(Direction.WEST)) {
                return right ? "middle" : "right";
            }
            return right ? "left" : "";
        });
        ConnectedModelRegistry.registerType("vertical", predicate -> {
            boolean bottom = predicate.test(Direction.SOUTH);
            if (predicate.test(Direction.NORTH)) {
                return bottom ? "middle" : "bottom";
            }
            return bottom ? "top" : "";
        });
        ConnectedModelRegistry.registerType("top", predicate -> predicate.test(Direction.NORTH) ? "bottom" : "");
    }
}

