/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management.linksession;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class LinkSession {
    private final HashMap<UUID, String> members = new HashMap();

    protected LinkSession() {
    }

    protected void addOrUpdateMember(UUID memberUUID, @Nullable String displayName) {
        String string = displayName = displayName == null ? "null" : displayName;
        if (!this.members.containsKey(memberUUID)) {
            this.members.put(memberUUID, displayName);
        } else {
            this.members.replace(memberUUID, displayName);
        }
    }

    protected void removeMember(UUID memberUUID) {
        this.members.remove(memberUUID);
    }

    protected boolean isMember(UUID memberUUID) {
        return this.members.get(memberUUID) != null;
    }

    @Nullable
    protected String getMemberDisplayName(UUID memberUUID) {
        return this.members.get(memberUUID);
    }

    protected List<UUID> getMembersUUID() {
        return new ArrayList<UUID>(this.members.keySet());
    }

    protected List<String> getMembersDisplayNames() {
        return new ArrayList<String>(this.members.values());
    }

    protected CompoundTag writeToNBT() {
        CompoundTag data = new CompoundTag();
        this.members.forEach((uuid, name) -> data.m_128359_(uuid.toString(), name));
        return data;
    }

    protected static LinkSession createFromNBT(CompoundTag in) {
        LinkSession ls = new LinkSession();
        for (String key : in.m_128431_()) {
            ls.addOrUpdateMember(UUID.fromString(key), in.m_128461_(key));
        }
        return ls;
    }
}

