/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.TickedWorldOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.common.util.TriPredicate;

public class StructurePlacementUtils {
    public static void unloadStructure(Level world, BlockPos startPos, String name, Rotation rotation, Mirror mirror) {
        CreativeStructureHandler structure = new CreativeStructureHandler(world, startPos, name, new PlacementSettings(mirror, rotation), false);
        structure.getBluePrint().rotateWithMirror(rotation, mirror, world);
        StructurePlacer placer = new StructurePlacer(structure);
        placer.executeStructureStep(world, null, new BlockPos(0, 0, 0), StructurePlacer.Operation.BLOCK_REMOVAL, () -> placer.getIterator().increment((TriPredicate<BlueprintPositionInfo, BlockPos, IStructureHandler>)((TriPredicate)(info, pos, handler) -> handler.getWorld().m_8055_(pos).m_60734_() instanceof AirBlock)), true);
    }

    public static void loadAndPlaceStructureWithRotation(Level worldObj, String name, BlockPos pos, Rotation rotation, Mirror mirror, boolean fancyPlacement, ServerPlayer player) {
        try {
            CreativeStructureHandler structure = new CreativeStructureHandler(worldObj, pos, name, new PlacementSettings(mirror, rotation), fancyPlacement);
            structure.getBluePrint().rotateWithMirror(rotation, mirror, worldObj);
            StructurePlacer instantPlacer = new StructurePlacer(structure);
            Manager.addToQueue(new TickedWorldOperation(instantPlacer, (Player)player));
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public static void loadAndPlaceStructureWithRotation(Level worldObj, Blueprint blueprint, BlockPos pos, Rotation rotation, Mirror mirror, boolean fancyPlacement, ServerPlayer player) {
        try {
            CreativeStructureHandler structure = new CreativeStructureHandler(worldObj, pos, blueprint, new PlacementSettings(mirror, rotation), fancyPlacement);
            if (fancyPlacement) {
                structure.fancyPlacement();
            }
            structure.getBluePrint().rotateWithMirror(rotation, mirror, worldObj);
            StructurePlacer instantPlacer = new StructurePlacer(structure);
            Manager.addToQueue(new TickedWorldOperation(instantPlacer, (Player)player));
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }
}

