/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.client.AEStackRendering;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.stacks.AmountFormat;
import appeng.api.storage.AEKeyFilter;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.common.RepoSlot;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.client.gui.widgets.ToolboxPanel;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInteractionPacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ViewCellItem;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.crafting.CraftingStatusMenu;
import appeng.menu.me.interaction.EmptyingAction;
import appeng.menu.me.interaction.StackInteractions;
import appeng.util.IConfigManagerListener;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MEStorageScreen<C extends MEStorageMenu>
extends AEBaseScreen<C>
implements ISortSource,
IConfigManagerListener {
    private static final String TEXT_ID_ENTRIES_SHOWN = "entriesShown";
    private static final int MIN_ROWS = 3;
    private static String memoryText = "";
    private final appeng.client.gui.style.TerminalStyle style;
    protected final Repo repo;
    private final List<ItemStack> currentViewCells = new ArrayList<ItemStack>();
    private final IConfigManager configSrc;
    private final boolean supportsViewCells;
    private TabButton craftingStatusBtn;
    private final AETextField searchField;
    private int rows = 0;
    private SettingToggleButton<ViewItems> viewModeToggle;
    private SettingToggleButton<TypeFilter> filterTypesToggle;
    private SettingToggleButton<SortOrder> sortByToggle;
    private final SettingToggleButton<SortDir> sortDirToggle;
    private boolean isAutoFocus = false;
    private int currentMouseX = 0;
    private int currentMouseY = 0;
    private final Scrollbar scrollbar;

    public MEStorageScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.style = style.getTerminalStyle();
        if (this.style == null) {
            throw new IllegalStateException("Cannot construct screen " + this.getClass() + " without a terminalStyles setting");
        }
        this.searchField = this.widgets.addTextField("search");
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.repo = new Repo(this.scrollbar, this);
        ((MEStorageMenu)menu).setClientRepo(this.repo);
        this.repo.setUpdateViewListener(this::updateScrollbar);
        this.updateScrollbar();
        this.searchField.m_94151_(this::setSearchText);
        this.f_97726_ = this.style.getScreenWidth();
        this.f_97727_ = this.style.getScreenHeight(0);
        this.configSrc = ((IConfigurableObject)this.f_97732_).getConfigManager();
        ((MEStorageMenu)this.f_97732_).setGui(this);
        List<Slot> viewCellSlots = ((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.VIEW_CELL);
        boolean bl = this.supportsViewCells = !viewCellSlots.isEmpty();
        if (this.supportsViewCells) {
            List<MutableComponent> tooltip = Collections.singletonList(GuiText.TerminalViewCellsTooltip.text());
            this.widgets.add("viewCells", new UpgradesPanel(viewCellSlots, () -> tooltip));
        }
        if (this.style.isSupportsAutoCrafting()) {
            this.craftingStatusBtn = new TabButton(Icon.PERMISSION_CRAFT, (Component)GuiText.CraftingStatus.text(), this.f_96542_, btn -> this.showCraftingStatus());
            this.craftingStatusBtn.setHideEdge(true);
            this.widgets.add("craftingStatus", (AbstractWidget)this.craftingStatusBtn);
        }
        if (this.style.isSortable()) {
            this.sortByToggle = this.addToLeftToolbar(new SettingToggleButton<SortOrder>(Settings.SORT_BY, this.getSortBy(), Platform::isSortOrderAvailable, this::toggleServerSetting));
        }
        if (this.style.isSupportsAutoCrafting()) {
            this.viewModeToggle = this.addToLeftToolbar(new SettingToggleButton<ViewItems>(Settings.VIEW_MODE, this.getSortDisplay(), this::toggleServerSetting));
        }
        if (((MEStorageMenu)this.f_97732_).canConfigureTypeFilter()) {
            this.filterTypesToggle = this.addToLeftToolbar(new SettingToggleButton<TypeFilter>(Settings.TYPE_FILTER, this.getTypeFilter(), this::toggleServerSetting));
        }
        this.sortDirToggle = new SettingToggleButton<SortDir>(Settings.SORT_DIRECTION, this.getSortDir(), this::toggleServerSetting);
        this.addToLeftToolbar(this.sortDirToggle);
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        this.addToLeftToolbar(new SettingToggleButton<SearchBoxMode>(Settings.SEARCH_MODE, searchMode, Platform::isSearchModeAvailable, this::toggleTerminalSearchMode));
        if (this.style.getMaxRows() == null) {
            TerminalStyle terminalStyle = AEConfig.instance().getTerminalStyle();
            this.addToLeftToolbar(new SettingToggleButton<TerminalStyle>(Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        }
        this.widgets.add("upgrades", new UpgradesPanel(((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.UPGRADE), ((MEStorageMenu)menu).getHost()));
        if (((MEStorageMenu)menu).getToolbox().isPresent()) {
            this.widgets.add("toolbox", new ToolboxPanel(style, ((MEStorageMenu)menu).getToolbox().getName()));
        }
    }

    @Nullable
    protected IPartitionList createPartitionList(List<ItemStack> viewCells) {
        return ViewCellItem.createFilter(AEKeyFilter.none(), viewCells);
    }

    protected void handleGridInventoryEntryMouseClick(@Nullable GridInventoryEntry entry, int mouseButton, ClickType clickType) {
        EmptyingAction emptyingAction;
        if (entry != null) {
            AELog.debug("Clicked on grid inventory entry serial=%s, key=%s", entry.getSerial(), entry.getWhat());
        }
        if (mouseButton == 1 && clickType == ClickType.PICKUP && !((MEStorageMenu)this.f_97732_).m_142621_().m_41619_() && (emptyingAction = StackInteractions.getEmptyingAction(((MEStorageMenu)this.f_97732_).m_142621_())) != null && ((MEStorageMenu)this.f_97732_).isKeyVisible(emptyingAction.what())) {
            ((MEStorageMenu)this.f_97732_).handleInteraction(-1L, InventoryAction.EMPTY_ITEM);
            return;
        }
        if (entry == null) {
            if (clickType == ClickType.PICKUP && !((MEStorageMenu)this.m_6262_()).m_142621_().m_41619_()) {
                InventoryAction action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                ((MEStorageMenu)this.f_97732_).handleInteraction(-1L, action);
            }
            return;
        }
        long serial = entry.getSerial();
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)32)) {
            ((MEStorageMenu)this.f_97732_).handleInteraction(serial, InventoryAction.MOVE_REGION);
        } else {
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    InventoryAction inventoryAction = action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    if (action != InventoryAction.PICKUP_OR_SET_DOWN || !this.shouldCraftOnClick(entry) || !((MEStorageMenu)this.m_6262_()).m_142621_().m_41619_()) break;
                    ((MEStorageMenu)this.f_97732_).handleInteraction(serial, InventoryAction.AUTO_CRAFT);
                    return;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (entry.isCraftable()) {
                        ((MEStorageMenu)this.f_97732_).handleInteraction(serial, InventoryAction.AUTO_CRAFT);
                        return;
                    }
                    if (!((MEStorageMenu)this.m_6262_()).getPlayer().m_150110_().f_35937_) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((MEStorageMenu)this.f_97732_).handleInteraction(serial, action);
            }
        }
    }

    private boolean shouldCraftOnClick(GridInventoryEntry entry) {
        if (this.isViewOnlyCraftable()) {
            return true;
        }
        return entry.getStoredAmount() == 0L && entry.isCraftable();
    }

    private void updateScrollbar() {
        this.scrollbar.setHeight(this.rows * this.style.getRow().getSrcHeight() - 2);
        int totalRows = (this.repo.size() + this.getSlotsPerRow() - 1) / this.getSlotsPerRow();
        this.scrollbar.setRange(0, totalRows - this.rows, Math.max(1, this.rows / 6));
    }

    private void showCraftingStatus() {
        NetworkHandler.instance().sendToServer(SwitchGuisPacket.openSubMenu(CraftingStatusMenu.TYPE));
    }

    private int getSlotsPerRow() {
        return this.style.getSlotsPerRow();
    }

    @Override
    public void m_7856_() {
        this.getMinecraft().f_91068_.m_90926_(true);
        this.rows = Mth.m_14045_((int)this.style.getPossibleRows(this.f_96544_), (int)3, (int)this.getMaxRows());
        this.f_97727_ = this.style.getScreenHeight(this.rows);
        NonNullList slots = ((MEStorageMenu)this.f_97732_).f_38839_;
        slots.removeIf(slot -> slot instanceof RepoSlot);
        int repoIndex = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.style.getSlotsPerRow(); ++col) {
                Point pos = this.style.getSlotPos(row, col);
                slots.add(new RepoSlot(this.repo, repoIndex++, pos.getX(), pos.getY()));
            }
        }
        super.m_7856_();
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        this.isAutoFocus = searchMode.isAutoFocus();
        if (this.isAutoFocus) {
            this.m_94718_((GuiEventListener)this.searchField);
        }
        if (searchMode.isRememberSearch() && memoryText != null && !memoryText.isEmpty()) {
            this.searchField.m_94144_(memoryText);
            this.searchField.selectAll();
            this.setSearchText(memoryText);
        }
        this.updateScrollbar();
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.updateSearch();
        if (!this.f_96539_.getString().isEmpty()) {
            this.setTextContent("dialog_title", this.f_96539_);
        } else if (((MEStorageMenu)this.f_97732_).getTarget() instanceof IMEChest) {
            this.setTextContent("dialog_title", (Component)GuiText.Chest.text());
        }
    }

    private void updateSearch() {
        SearchBoxMode searchMode = AEConfig.instance().getTerminalSearchMode();
        if (searchMode.shouldUseExternalSearchBox()) {
            int visibleEntries;
            int allEntries;
            this.searchField.m_94194_(false);
            String externalSearchText = Platform.getExternalSearchText(searchMode);
            if (!Objects.equals(this.repo.getSearchString(), externalSearchText)) {
                this.setSearchText(externalSearchText);
            }
            if ((allEntries = this.repo.getAllEntries().size()) != (visibleEntries = this.repo.size())) {
                this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, false);
                this.setTextContent(TEXT_ID_ENTRIES_SHOWN, (Component)GuiText.ShowingOf.text(visibleEntries, allEntries));
            } else {
                this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, true);
            }
        } else {
            this.searchField.m_94194_(true);
            this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, true);
        }
    }

    @Override
    public void drawFG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        if (this.craftingStatusBtn != null && ((MEStorageMenu)this.f_97732_).activeCraftingJobs != -1) {
            int x = this.craftingStatusBtn.f_93620_ + (this.craftingStatusBtn.m_5711_() - 16) / 2;
            int y = this.craftingStatusBtn.f_93621_ + (this.craftingStatusBtn.m_93694_() - 16) / 2;
            StackSizeRenderer.renderSizeLabel(this.f_96547_, x - this.f_97735_, y - this.f_97736_, String.valueOf(((MEStorageMenu)this.f_97732_).activeCraftingJobs));
        }
    }

    @Override
    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        RepoSlot repoSlot;
        Slot slot;
        if (this.searchField.m_5953_(xCoord, yCoord) && btn == 1) {
            this.searchField.m_94144_("");
            this.setSearchText("");
            return true;
        }
        if (this.f_96541_.f_91066_.f_92097_.m_90830_(btn) && (slot = this.m_97744_(xCoord, yCoord)) instanceof RepoSlot && (repoSlot = (RepoSlot)slot).isCraftable()) {
            this.handleGridInventoryEntryMouseClick(repoSlot.getEntry(), btn, ClickType.CLONE);
            return true;
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    @Override
    public boolean m_6050_(double x, double y, double wheelDelta) {
        Slot slot;
        if (wheelDelta != 0.0 && MEStorageScreen.m_96638_() && (slot = this.m_97744_(x, y)) instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)slot;
            GridInventoryEntry entry = repoSlot.getEntry();
            long serial = entry != null ? entry.getSerial() : -1L;
            InventoryAction direction = wheelDelta > 0.0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = (int)Math.abs(wheelDelta);
            for (int h = 0; h < times; ++h) {
                MEInteractionPacket p = new MEInteractionPacket(((MEStorageMenu)this.f_97732_).f_38840_, serial, direction);
                NetworkHandler.instance().sendToServer(p);
            }
            return true;
        }
        return super.m_6050_(x, y, wheelDelta);
    }

    @Override
    protected void m_6597_(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)slot;
            this.handleGridInventoryEntryMouseClick(repoSlot.getEntry(), mouseButton, clickType);
            return;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    public void m_7861_() {
        super.m_7861_();
        this.getMinecraft().f_91068_.m_90926_(false);
        memoryText = this.searchField.m_94155_();
    }

    @Override
    public void drawBG(PoseStack poseStack, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.style.getHeader().dest(offsetX, offsetY).blit(poseStack, this.m_93252_());
        int y = offsetY;
        this.style.getHeader().dest(offsetX, y).blit(poseStack, this.m_93252_());
        y += this.style.getHeader().getSrcHeight();
        int rowsToDraw = Math.max(2, this.rows);
        for (int x = 0; x < rowsToDraw; ++x) {
            Blitter row = this.style.getRow();
            if (x == 0) {
                row = this.style.getFirstRow();
            } else if (x + 1 == rowsToDraw) {
                row = this.style.getLastRow();
            }
            row.dest(offsetX, y).blit(poseStack, this.m_93252_());
            y += this.style.getRow().getSrcHeight();
        }
        this.style.getBottom().dest(offsetX, y).blit(poseStack, this.m_93252_());
        if (this.searchField != null) {
            this.searchField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void m_97799_(PoseStack poseStack, Slot s) {
        if (s instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)s;
            if (!this.repo.hasPower()) {
                MEStorageScreen.m_93172_((PoseStack)poseStack, (int)s.f_40220_, (int)s.f_40221_, (int)(16 + s.f_40220_), (int)(16 + s.f_40221_), (int)0x66111111);
            } else {
                GridInventoryEntry entry = repoSlot.getEntry();
                if (entry != null) {
                    try {
                        AEStackRendering.drawInGui(this.f_96541_, poseStack, s.f_40220_, s.f_40221_, this.m_93252_(), entry.getWhat());
                    }
                    catch (Exception err) {
                        AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
                    }
                    long storedAmount = entry.getStoredAmount();
                    boolean craftable = entry.isCraftable();
                    boolean useLargeFonts = AEConfig.instance().isUseLargeFonts();
                    if (craftable && (this.isViewOnlyCraftable() || storedAmount <= 0L)) {
                        String craftLabelText = useLargeFonts ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
                        StackSizeRenderer.renderSizeLabel(this.f_96547_, s.f_40220_, s.f_40221_, craftLabelText);
                    } else {
                        AmountFormat format = useLargeFonts ? AmountFormat.PREVIEW_LARGE_FONT : AmountFormat.PREVIEW_REGULAR;
                        String text = entry.getWhat().formatAmount(storedAmount, format);
                        StackSizeRenderer.renderSizeLabel(this.f_96547_, s.f_40220_, s.f_40221_, text, useLargeFonts);
                    }
                }
            }
            return;
        }
        super.m_97799_(poseStack, s);
    }

    protected final boolean isViewOnlyCraftable() {
        return this.viewModeToggle != null && this.viewModeToggle.getCurrentValue() == ViewItems.CRAFTABLE;
    }

    protected void m_7025_(PoseStack poseStack, int x, int y) {
        Slot slot = this.f_97734_;
        if (slot instanceof RepoSlot) {
            GridInventoryEntry entry;
            EmptyingAction emptyingAction;
            RepoSlot repoSlot = (RepoSlot)slot;
            ItemStack carried = ((MEStorageMenu)this.f_97732_).m_142621_();
            if (!carried.m_41619_() && (emptyingAction = StackInteractions.getEmptyingAction(carried)) != null && ((MEStorageMenu)this.f_97732_).isKeyVisible(emptyingAction.what())) {
                this.drawTooltip(poseStack, x, y, Tooltips.getEmptyingTooltip(ButtonToolTips.StoreAction, carried, emptyingAction));
                return;
            }
            if (carried.m_41619_() && (entry = repoSlot.getEntry()) != null) {
                this.renderGridInventoryEntryTooltip(poseStack, entry, x, y);
            }
            return;
        }
        super.m_7025_(poseStack, x, y);
    }

    protected void renderGridInventoryEntryTooltip(PoseStack poseStack, GridInventoryEntry entry, int x, int y) {
        long requestableAmount;
        List<Component> currentToolTip = AEStackRendering.getTooltip(entry.getWhat());
        if (Tooltips.shouldShowAmountTooltip(entry.getWhat(), entry.getStoredAmount())) {
            currentToolTip.add(Tooltips.getAmountTooltip(ButtonToolTips.StoredAmount, entry.getWhat(), entry.getStoredAmount()));
        }
        if ((requestableAmount = entry.getRequestableAmount()) > 0L) {
            String formattedAmount = entry.getWhat().formatAmount(requestableAmount, AmountFormat.FULL);
            currentToolTip.add((Component)ButtonToolTips.RequestableAmount.text(formattedAmount));
        }
        if (entry.isCraftable() && !this.isViewOnlyCraftable() && entry.getStoredAmount() > 0L) {
            currentToolTip.add((Component)ButtonToolTips.Craftable.text().m_6881_().m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            currentToolTip.add((Component)new TextComponent("Serial: " + entry.getSerial()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        this.m_96597_(poseStack, currentToolTip, x, y);
    }

    private int getMaxRows() {
        Integer maxRows = this.style.getMaxRows();
        if (maxRows != null) {
            return maxRows;
        }
        return AEConfig.instance().getTerminalStyle() == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
    }

    public boolean m_5534_(char character, int modifiers) {
        if (character == ' ' && this.searchField.m_94155_().isEmpty()) {
            return true;
        }
        if (this.isAutoFocus && !this.searchField.m_93696_() && this.isHovered()) {
            this.m_94718_((GuiEventListener)this.searchField);
        }
        return super.m_5534_(character, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int p_keyPressed_3_) {
        InputConstants.Key input = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.checkHotbarKeys(input)) {
            return true;
        }
        if (this.searchField.m_93696_() && keyCode == 257) {
            this.searchField.m_94178_(false);
            this.m_7522_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, p_keyPressed_3_);
    }

    private boolean isHovered() {
        return this.m_6774_(0, 0, this.f_97726_, this.f_97727_, this.currentMouseX, this.currentMouseY);
    }

    @Override
    public void m_181908_() {
        List<ItemStack> viewCells;
        this.repo.setPower(((MEStorageMenu)this.f_97732_).isPowered());
        if (this.supportsViewCells && !this.currentViewCells.equals(viewCells = ((MEStorageMenu)this.f_97732_).getViewCells())) {
            this.currentViewCells.clear();
            this.currentViewCells.addAll(viewCells);
            this.repo.setPartitionList(this.createPartitionList(viewCells));
        }
        super.m_181908_();
    }

    @Override
    public SortOrder getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public SortDir getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public ViewItems getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public TypeFilter getTypeFilter() {
        return this.configSrc.getSetting(Settings.TYPE_FILTER);
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (this.sortByToggle != null) {
            this.sortByToggle.set(this.getSortBy());
        }
        if (this.sortDirToggle != null) {
            this.sortDirToggle.set(this.getSortDir());
        }
        if (this.viewModeToggle != null) {
            this.viewModeToggle.set(this.getSortDisplay());
        }
        if (this.filterTypesToggle != null) {
            this.filterTypesToggle.set(this.getTypeFilter());
        }
        this.repo.updateView();
    }

    private void toggleTerminalSearchMode(SettingToggleButton<SearchBoxMode> btn, boolean backwards) {
        SearchBoxMode currentMode = AEConfig.instance().getTerminalSearchMode();
        SearchBoxMode next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalSearchMode(next);
        btn.set(next);
        this.reinitalize();
        SearchBoxMode newMode = AEConfig.instance().getTerminalSearchMode();
        if (!newMode.shouldUseExternalSearchBox()) {
            this.setSearchText(this.searchField.m_94155_());
        }
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        btn.set(next);
        this.reinitalize();
    }

    private <SE extends Enum<SE>> void toggleServerSetting(SettingToggleButton<SE> btn, boolean backwards) {
        SE next = btn.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket(btn.getSetting(), next));
        btn.set(next);
    }

    private void setSearchText(String text) {
        this.repo.setSearchString(text);
        this.repo.updateView();
        this.updateScrollbar();
    }

    private void reinitalize() {
        new ArrayList<GuiEventListener>(this.m_6702_()).forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.m_7856_();
    }
}

