/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.Rects;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.client.gui.widgets.ValidationIcon;
import com.mojang.blaze3d.vertex.PoseStack;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public class NumberEntryWidget
extends GuiComponent
implements ICompositeWidget {
    private static final long[] STEPS = new long[]{1L, 10L, 100L, 1000L};
    private static final Component INVALID_NUMBER = new TranslatableComponent("gui.ae2.validation.InvalidNumber");
    private static final String NUMBER_LESS_THAN_MIN_VALUE = "gui.ae2.validation.NumberLessThanMinValue";
    private static final String NUMBER_GREATER_THAN_MAX_VALUE = "gui.ae2.validation.NumberGreaterThanMaxValue";
    private static final Component PLUS = new TextComponent("+");
    private static final Component MINUS = new TextComponent("-");
    private static final int TEXT_COLOR_ERROR = 16718080;
    private static final int TEXT_COLOR_NORMAL = 0xFFFFFF;
    private final ConfirmableTextField textField;
    private final DecimalFormat decimalFormat;
    private NumberEntryType type;
    private List<Button> buttons;
    private long minValue;
    private long maxValue = Long.MAX_VALUE;
    private ValidationIcon validationIcon;
    private Runnable onChange;
    private Runnable onConfirm;
    private boolean hideValidationIcon;
    private Rect2i bounds = new Rect2i(0, 0, 0, 0);
    private Rect2i textFieldBounds = Rects.ZERO;

    public NumberEntryWidget(NumberEntryType type) {
        this.type = Objects.requireNonNull(type, "type");
        this.decimalFormat = new DecimalFormat("#.####", new DecimalFormatSymbols());
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setNegativePrefix("-");
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        this.textField = new ConfirmableTextField(font, 0, 0, 0, 9);
        this.textField.m_94182_(false);
        this.textField.m_94199_(16);
        this.textField.m_94202_(0xFFFFFF);
        this.textField.m_94194_(true);
        this.textField.m_94178_(true);
        this.textField.m_94151_(text -> {
            this.validate();
            if (this.onChange != null) {
                this.onChange.run();
            }
        });
        this.textField.setOnConfirm(() -> {
            if (this.onConfirm != null && this.getLongValue().isPresent()) {
                this.onConfirm.run();
            }
        });
        this.validate();
    }

    public void setOnConfirm(Runnable callback) {
        this.onConfirm = callback;
    }

    public void setOnChange(Runnable callback) {
        this.onChange = callback;
    }

    public void setActive(boolean active) {
        this.textField.m_94186_(active);
        this.buttons.forEach(b -> {
            b.f_93623_ = active;
        });
    }

    public void setTextFieldBounds(Rect2i bounds) {
        this.textFieldBounds = bounds;
        this.textField.move(Point.fromTopLeft(bounds));
        this.textField.resize(bounds.m_110090_(), bounds.m_110091_());
    }

    public void setTextFieldStyle(WidgetStyle style) {
        int left = 0;
        if (style.getLeft() != null) {
            left = style.getLeft();
        }
        int top = 0;
        if (style.getTop() != null) {
            top = style.getTop();
        }
        this.setTextFieldBounds(new Rect2i(left, top, style.getWidth(), style.getHeight()));
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
        this.validate();
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
        this.validate();
    }

    @Override
    public void setPosition(Point position) {
        this.bounds = new Rect2i(position.getX(), position.getY(), this.bounds.m_110090_(), this.bounds.m_110091_());
    }

    @Override
    public void setSize(int width, int height) {
        this.bounds = new Rect2i(this.bounds.m_110085_(), this.bounds.m_110086_(), width, height);
    }

    @Override
    public Rect2i getBounds() {
        return this.bounds;
    }

    @Override
    public void populateScreen(Consumer<AbstractWidget> addWidget, Rect2i bounds, AEBaseScreen<?> screen) {
        int left = bounds.m_110085_() + this.bounds.m_110085_();
        int top = bounds.m_110086_() + this.bounds.m_110086_();
        ArrayList<Button> buttons = new ArrayList<Button>(9);
        buttons.add(new Button(left, top, 22, 20, this.makeLabel(PLUS, STEPS[0]), btn -> this.addQty(STEPS[0])));
        buttons.add(new Button(left + 28, top, 28, 20, this.makeLabel(PLUS, STEPS[1]), btn -> this.addQty(STEPS[1])));
        buttons.add(new Button(left + 62, top, 32, 20, this.makeLabel(PLUS, STEPS[2]), btn -> this.addQty(STEPS[2])));
        buttons.add(new Button(left + 100, top, 38, 20, this.makeLabel(PLUS, STEPS[3]), btn -> this.addQty(STEPS[3])));
        buttons.forEach(addWidget);
        Rect2i textFieldBounds = Rects.move(this.textFieldBounds, bounds.m_110085_(), bounds.m_110086_());
        this.textField.move(Point.fromTopLeft(textFieldBounds));
        this.textField.resize(textFieldBounds.m_110090_(), textFieldBounds.m_110091_());
        screen.m_94718_((GuiEventListener)this.textField);
        addWidget.accept((AbstractWidget)this.textField);
        buttons.add(new Button(left, top + 42, 22, 20, this.makeLabel(MINUS, STEPS[0]), btn -> this.addQty(-STEPS[0])));
        buttons.add(new Button(left + 28, top + 42, 28, 20, this.makeLabel(MINUS, STEPS[1]), btn -> this.addQty(-STEPS[1])));
        buttons.add(new Button(left + 62, top + 42, 32, 20, this.makeLabel(MINUS, STEPS[2]), btn -> this.addQty(-STEPS[2])));
        buttons.add(new Button(left + 100, top + 42, 38, 20, this.makeLabel(MINUS, STEPS[3]), btn -> this.addQty(-STEPS[3])));
        if (!this.hideValidationIcon) {
            this.validationIcon = new ValidationIcon();
            this.validationIcon.f_93620_ = left + 104;
            this.validationIcon.f_93621_ = top + 27;
            buttons.add(this.validationIcon);
        }
        buttons.subList(4, buttons.size()).forEach(addWidget);
        this.buttons = buttons;
        this.validate();
        screen.m_5755_(true);
    }

    public OptionalInt getIntValue() {
        OptionalLong value = this.getLongValue();
        if (value.isPresent()) {
            long longValue = value.getAsLong();
            if (longValue > Integer.MAX_VALUE) {
                return OptionalInt.empty();
            }
            return OptionalInt.of((int)longValue);
        }
        return OptionalInt.empty();
    }

    public OptionalLong getLongValue() {
        Optional<BigDecimal> internalValue = this.getValueInternal();
        if (internalValue.isEmpty()) {
            return OptionalLong.empty();
        }
        long externalValue = this.convertToExternalValue(internalValue.get());
        if (externalValue < this.minValue) {
            return OptionalLong.empty();
        }
        if (externalValue > this.maxValue) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(externalValue);
    }

    public void setLongValue(long value) {
        BigDecimal internalValue = this.convertToInternalValue(Mth.m_14053_((long)value, (long)this.minValue, (long)this.maxValue));
        this.textField.m_94144_(this.decimalFormat.format(internalValue));
        this.textField.m_94201_();
        this.textField.m_94208_(0);
        this.validate();
    }

    private void addQty(long delta) {
        BigDecimal currentValue = this.getValueInternal().orElse(BigDecimal.ZERO);
        this.setValueInternal(currentValue.add(BigDecimal.valueOf(delta)));
    }

    private Optional<BigDecimal> getValueInternal() {
        ParsePosition position = new ParsePosition(0);
        String textValue = this.textField.m_94155_().trim();
        BigDecimal decimal = (BigDecimal)this.decimalFormat.parse(textValue, position);
        if (position.getErrorIndex() != -1 || position.getIndex() != textValue.length()) {
            return Optional.empty();
        }
        return Optional.ofNullable(decimal);
    }

    private void setValueInternal(BigDecimal value) {
        this.textField.m_94144_(this.decimalFormat.format(value));
    }

    private void validate() {
        ArrayList<Component> validationErrors = new ArrayList<Component>();
        Optional<BigDecimal> possibleValue = this.getValueInternal();
        if (possibleValue.isPresent()) {
            if (this.type.amountPerUnit() == 1 && possibleValue.get().scale() > 0) {
                validationErrors.add((Component)new TextComponent("Must be whole number"));
            } else {
                long value = this.convertToExternalValue(possibleValue.get());
                if (value < this.minValue) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(this.minValue));
                    validationErrors.add((Component)new TranslatableComponent(NUMBER_LESS_THAN_MIN_VALUE, new Object[]{formatted}));
                } else if (value > this.maxValue) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(this.maxValue));
                    validationErrors.add((Component)new TranslatableComponent(NUMBER_GREATER_THAN_MAX_VALUE, new Object[]{formatted}));
                }
            }
        } else {
            validationErrors.add(INVALID_NUMBER);
        }
        boolean valid = validationErrors.isEmpty();
        this.textField.m_94202_(valid ? 0xFFFFFF : 16718080);
        this.textField.setTooltipMessage(validationErrors);
        if (this.validationIcon != null) {
            this.validationIcon.setValid(valid);
            this.validationIcon.setTooltip(validationErrors);
        }
    }

    private Component makeLabel(Component prefix, long amount) {
        return prefix.m_6879_().m_130946_(this.decimalFormat.format(amount));
    }

    public void setHideValidationIcon(boolean hideValidationIcon) {
        this.hideValidationIcon = hideValidationIcon;
    }

    public NumberEntryType getType() {
        return this.type;
    }

    public void setType(NumberEntryType type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        if (this.onChange != null) {
            this.onChange.run();
        }
        this.validate();
    }

    private long convertToExternalValue(BigDecimal internalValue) {
        BigDecimal multiplicand = BigDecimal.valueOf(this.type.amountPerUnit());
        BigDecimal value = internalValue.multiply(multiplicand, MathContext.DECIMAL128);
        value = value.setScale(0, RoundingMode.UP);
        return value.longValue();
    }

    private BigDecimal convertToInternalValue(long externalValue) {
        BigDecimal divisor = BigDecimal.valueOf(this.type.amountPerUnit());
        return BigDecimal.valueOf(externalValue).divide(divisor, MathContext.DECIMAL128);
    }

    @Override
    public void drawBackgroundLayer(PoseStack poseStack, int zIndex, Rect2i bounds, Point mouse) {
        if (this.type.unit() != null) {
            Font font = Minecraft.m_91087_().f_91062_;
            String string = this.type.unit();
            float f = bounds.m_110085_() + this.textFieldBounds.m_110085_() + this.textFieldBounds.m_110090_() + 3;
            float f2 = bounds.m_110086_() + this.textFieldBounds.m_110086_();
            int n = this.textFieldBounds.m_110091_();
            Objects.requireNonNull(font);
            font.m_92883_(poseStack, string, f, f2 + (float)(n - 9) / 2.0f + 1.0f, ChatFormatting.DARK_GRAY.m_126665_().intValue());
        }
    }

    @Override
    public boolean onMouseWheel(Point mousePos, double delta) {
        if (this.textFieldBounds.m_110087_(mousePos.getX(), mousePos.getY())) {
            if (delta < 0.0) {
                BigDecimal minValueInternal = this.convertToInternalValue(this.minValue);
                if (this.getValueInternal().orElse(minValueInternal).subtract(BigDecimal.ONE).compareTo(minValueInternal) >= 0) {
                    this.addQty(-1L);
                } else {
                    this.setValueInternal(minValueInternal);
                }
            } else if (delta > 0.0) {
                BigDecimal maxValueInternal = this.convertToInternalValue(this.maxValue);
                if (this.getValueInternal().orElse(maxValueInternal).add(BigDecimal.ONE).compareTo(maxValueInternal) <= 0) {
                    this.addQty(1L);
                } else {
                    this.setValueInternal(maxValueInternal);
                }
            }
            return true;
        }
        return false;
    }
}

