/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.client.render.effects.LightningArcParticleData;
import appeng.client.render.effects.LightningFX;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LightningArcFX
extends LightningFX {
    private static final Random RANDOM_GENERATOR = new Random();
    private final double rx;
    private final double ry;
    private final double rz;

    public LightningArcFX(ClientLevel level, double x, double y, double z, double ex, double ey, double ez, double r, double g, double b) {
        super(level, x, y, z, r, g, b, 6);
        this.rx = ex - x;
        this.ry = ey - y;
        this.rz = ez - z;
        this.regen();
    }

    @Override
    protected void regen() {
        double i = 1.0 / (double)(this.getSteps() - 1);
        double lastDirectionX = this.rx * i;
        double lastDirectionY = this.ry * i;
        double lastDirectionZ = this.rz * i;
        double len = Math.sqrt(lastDirectionX * lastDirectionX + lastDirectionY * lastDirectionY + lastDirectionZ * lastDirectionZ);
        for (int s = 0; s < this.getSteps(); ++s) {
            double[][] localSteps = this.getPrecomputedSteps();
            localSteps[s][0] = (lastDirectionX + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
            localSteps[s][1] = (lastDirectionY + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
            localSteps[s][2] = (lastDirectionZ + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<LightningArcParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(LightningArcParticleData data, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LightningArcFX lightningFX = new LightningArcFX(level, x, y, z, data.target.f_82479_, data.target.f_82480_, data.target.f_82481_, 0.0, 0.0, 0.0);
            lightningFX.m_108335_(this.spriteSet);
            return lightningFX;
        }
    }
}

