/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.registries.ForgeRegistries;

public class SwitchGuisPacket
extends BasePacket {
    @Nullable
    private final MenuType<?> newGui;

    public SwitchGuisPacket(FriendlyByteBuf stream) {
        this.newGui = stream.readBoolean() ? (MenuType)ForgeRegistries.CONTAINERS.getValue(stream.m_130281_()) : null;
    }

    private SwitchGuisPacket(@Nullable MenuType<? extends ISubMenu> newGui) {
        this.newGui = null;
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        if (newGui != null) {
            data.writeBoolean(true);
            data.m_130085_(newGui.getRegistryName());
        } else {
            data.writeBoolean(false);
        }
        this.configureWrite(data);
    }

    public static SwitchGuisPacket openSubMenu(MenuType<? extends ISubMenu> menuType) {
        return new SwitchGuisPacket(menuType);
    }

    public static SwitchGuisPacket returnToParentMenu() {
        return new SwitchGuisPacket((MenuType<? extends ISubMenu>)((MenuType)null));
    }

    @Override
    public void serverPacketData(INetworkInfo manager, ServerPlayer player) {
        if (this.newGui != null) {
            this.doOpenSubMenu(player);
        } else {
            this.doReturnToParentMenu(player);
        }
    }

    private void doOpenSubMenu(ServerPlayer player) {
        AEBaseMenu bc;
        MenuLocator locator;
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof AEBaseMenu && (locator = (bc = (AEBaseMenu)abstractContainerMenu).getLocator()) != null) {
            MenuOpener.open(this.newGui, (Player)player, locator);
        }
    }

    private void doReturnToParentMenu(ServerPlayer player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ISubMenu) {
            ISubMenu subMenu = (ISubMenu)abstractContainerMenu;
            subMenu.getHost().returnToMainMenu((Player)player, subMenu);
        }
    }
}

