/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.tags;

import appeng.api.ids.AETags;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.tags.ConventionTags;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockTagsProvider
extends net.minecraft.data.tags.BlockTagsProvider
implements IAE2DataProvider {
    private static final BlockDefinition<?>[] SKY_STONE_BLOCKS = new BlockDefinition[]{AEBlocks.SKY_STONE_BLOCK, AEBlocks.SMOOTH_SKY_STONE_BLOCK, AEBlocks.SKY_STONE_BRICK, AEBlocks.SKY_STONE_SMALL_BRICK, AEBlocks.SKY_STONE_CHEST, AEBlocks.SMOOTH_SKY_STONE_CHEST, AEBlocks.SKY_STONE_STAIRS, AEBlocks.SMOOTH_SKY_STONE_STAIRS, AEBlocks.SKY_STONE_BRICK_STAIRS, AEBlocks.SKY_STONE_SMALL_BRICK_STAIRS, AEBlocks.SKY_STONE_WALL, AEBlocks.SMOOTH_SKY_STONE_WALL, AEBlocks.SKY_STONE_BRICK_WALL, AEBlocks.SKY_STONE_SMALL_BRICK_WALL, AEBlocks.SKY_STONE_SLAB, AEBlocks.SMOOTH_SKY_STONE_SLAB, AEBlocks.SKY_STONE_BRICK_SLAB, AEBlocks.SKY_STONE_SMALL_BRICK_SLAB};

    public BlockTagsProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "ae2", existingFileHelper);
    }

    protected void m_6577_() {
        this.m_206424_(AETags.SPATIAL_BLACKLIST).m_126582_((Object)Blocks.f_50752_);
        this.m_206424_(AETags.ANNIHILATION_PLANE_BLOCK_BLACKLIST);
        this.m_206424_(AETags.FACADE_BLOCK_WHITELIST).m_126584_((Object[])new Block[]{Blocks.f_50058_, AEBlocks.QUARTZ_GLASS.block(), AEBlocks.QUARTZ_VIBRANT_GLASS.block()}).m_206428_(ConventionTags.STAINED_GLASS_BLOCK);
        this.m_206424_(ConventionTags.CERTUS_QUARTZ_ORE_BLOCK).m_126582_((Object)AEBlocks.QUARTZ_ORE.block()).m_126582_((Object)AEBlocks.DEEPSLATE_QUARTZ_ORE.block());
        this.m_206424_(Tags.Blocks.ORES).m_206428_(ConventionTags.CERTUS_QUARTZ_ORE_BLOCK);
        this.m_206424_(ConventionTags.CERTUS_QUARTZ_STORAGE_BLOCK_BLOCK).m_126582_((Object)AEBlocks.QUARTZ_BLOCK.block());
        this.m_206424_(Tags.Blocks.STORAGE_BLOCKS).m_206428_(ConventionTags.CERTUS_QUARTZ_STORAGE_BLOCK_BLOCK);
        this.m_206424_(ConventionTags.TERRACOTTA_BLOCK).m_126584_((Object[])new Block[]{Blocks.f_50352_, Blocks.f_50287_, Blocks.f_50288_, Blocks.f_50289_, Blocks.f_50290_, Blocks.f_50291_, Blocks.f_50292_, Blocks.f_50293_, Blocks.f_50294_, Blocks.f_50295_, Blocks.f_50296_, Blocks.f_50297_, Blocks.f_50298_, Blocks.f_50299_, Blocks.f_50300_, Blocks.f_50301_, Blocks.f_50302_});
        this.m_206424_(BlockTags.f_13032_).m_126584_((Object[])new Block[]{AEBlocks.SKY_STONE_WALL.block(), AEBlocks.SMOOTH_SKY_STONE_WALL.block(), AEBlocks.SKY_STONE_BRICK_WALL.block(), AEBlocks.SKY_STONE_SMALL_BRICK_WALL.block(), AEBlocks.FLUIX_WALL.block(), AEBlocks.QUARTZ_WALL.block(), AEBlocks.CHISELED_QUARTZ_WALL.block(), AEBlocks.QUARTZ_PILLAR_WALL.block()});
        this.addEffectiveTools();
    }

    private void addEffectiveTools() {
        HashMap specialTags = new HashMap();
        for (BlockDefinition<?> skyStoneBlock : SKY_STONE_BLOCKS) {
            specialTags.put(skyStoneBlock, List.of(BlockTags.f_144282_, BlockTags.f_144285_));
        }
        List<TagKey> defaultTags = List.of(BlockTags.f_144282_);
        for (BlockDefinition<?> block : AEBlocks.getBlocks()) {
            for (TagKey desiredTag : specialTags.getOrDefault(block, defaultTags)) {
                this.m_206424_(desiredTag).m_126582_(block.block());
            }
        }
    }

    protected Path m_6648_(ResourceLocation id) {
        return this.f_126539_.m_123916_().resolve("data/" + id.m_135827_() + "/tags/blocks/" + id.m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Applied Energistics 2 Block Tags";
    }
}

