/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.block.paint.PaintSplotchesModel;
import appeng.block.qnb.QnbFormedModel;
import appeng.client.render.FacadeItemModel;
import appeng.client.render.SimpleModelLoader;
import appeng.client.render.cablebus.CableBusModel;
import appeng.client.render.cablebus.P2PTunnelFrequencyModel;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.client.render.model.BiometricCardModel;
import appeng.client.render.model.ColorApplicatorModel;
import appeng.client.render.model.DriveModel;
import appeng.client.render.model.GlassModel;
import appeng.client.render.model.MemoryCardModel;
import appeng.client.render.model.SkyCompassModel;
import appeng.client.render.spatial.SpatialPylonModel;
import appeng.core.AppEng;
import appeng.parts.automation.PlaneModel;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometry;

@OnlyIn(value=Dist.CLIENT)
public final class InitBuiltInModels {
    private InitBuiltInModels() {
    }

    public static void init() {
        InitBuiltInModels.addBuiltInModel("block/cable_bus", CableBusModel::new);
        InitBuiltInModels.addBuiltInModel("block/quartz_glass", GlassModel::new);
        InitBuiltInModels.addBuiltInModel("block/sky_compass", SkyCompassModel::new);
        InitBuiltInModels.addBuiltInModel("item/sky_compass", SkyCompassModel::new);
        InitBuiltInModels.addBuiltInModel("item/memory_card", MemoryCardModel::new);
        InitBuiltInModels.addBuiltInModel("item/biometric_card", BiometricCardModel::new);
        InitBuiltInModels.addBuiltInModel("block/drive", DriveModel::new);
        InitBuiltInModels.addBuiltInModel("color_applicator", ColorApplicatorModel::new);
        InitBuiltInModels.addBuiltInModel("block/spatial_pylon", SpatialPylonModel::new);
        InitBuiltInModels.addBuiltInModel("block/paint", PaintSplotchesModel::new);
        InitBuiltInModels.addBuiltInModel("block/qnb/qnb_formed", QnbFormedModel::new);
        InitBuiltInModels.addBuiltInModel("part/p2p/p2p_tunnel_frequency", P2PTunnelFrequencyModel::new);
        InitBuiltInModels.addBuiltInModel("item/facade", FacadeItemModel::new);
        InitBuiltInModels.addPlaneModel("part/annihilation_plane", "part/annihilation_plane");
        InitBuiltInModels.addPlaneModel("part/annihilation_plane_on", "part/annihilation_plane_on");
        InitBuiltInModels.addPlaneModel("part/identity_annihilation_plane", "part/identity_annihilation_plane");
        InitBuiltInModels.addPlaneModel("part/identity_annihilation_plane_on", "part/identity_annihilation_plane_on");
        InitBuiltInModels.addPlaneModel("part/formation_plane", "part/formation_plane");
        InitBuiltInModels.addPlaneModel("part/formation_plane_on", "part/formation_plane_on");
        InitBuiltInModels.addBuiltInModel("block/crafting/1k_storage_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_1K));
        InitBuiltInModels.addBuiltInModel("block/crafting/4k_storage_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_4K));
        InitBuiltInModels.addBuiltInModel("block/crafting/16k_storage_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_16K));
        InitBuiltInModels.addBuiltInModel("block/crafting/64k_storage_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.STORAGE_64K));
        InitBuiltInModels.addBuiltInModel("block/crafting/accelerator_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.ACCELERATOR));
        InitBuiltInModels.addBuiltInModel("block/crafting/monitor_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.MONITOR));
        InitBuiltInModels.addBuiltInModel("block/crafting/unit_formed", () -> new CraftingCubeModel(AbstractCraftingUnitBlock.CraftingUnitType.UNIT));
    }

    private static void addPlaneModel(String planeName, String frontTexture) {
        ResourceLocation frontTextureId = AppEng.makeId(frontTexture);
        ResourceLocation sidesTextureId = AppEng.makeId("part/plane_sides");
        ResourceLocation backTextureId = AppEng.makeId("part/transition_plane_back");
        InitBuiltInModels.addBuiltInModel(planeName, () -> new PlaneModel(frontTextureId, sidesTextureId, backTextureId));
    }

    private static <T extends IModelGeometry<T>> void addBuiltInModel(String id, Supplier<T> modelFactory) {
        ModelLoaderRegistry.registerLoader((ResourceLocation)new ResourceLocation("ae2", id), new SimpleModelLoader<T>(modelFactory));
    }
}

