/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.client;

import appeng.api.util.AEColor;
import appeng.client.render.StaticItemColor;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.items.misc.PaintBallItem;
import appeng.items.parts.ColoredPartItem;
import appeng.items.parts.PartItem;
import appeng.items.storage.BasicStorageCell;
import appeng.items.tools.powered.ColorApplicatorItem;
import appeng.items.tools.powered.PortableCellItem;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class InitItemColors {
    private InitItemColors() {
    }

    public static void init(ItemColors itemColors) {
        itemColors.m_92689_((ItemColor)new StaticItemColor(AEColor.TRANSPARENT), new ItemLike[]{AEBlocks.SECURITY_STATION.m_5456_()});
        itemColors.m_92689_((ItemColor)new StaticItemColor(AEColor.TRANSPARENT), new ItemLike[]{AEBlocks.CHEST.m_5456_()});
        itemColors.m_92689_(InitItemColors::getColorApplicatorColor, new ItemLike[]{AEItems.COLOR_APPLICATOR});
        itemColors.m_92689_(PortableCellItem::getColor, new ItemLike[]{AEItems.PORTABLE_ITEM_CELL1K, AEItems.PORTABLE_ITEM_CELL4K, AEItems.PORTABLE_ITEM_CELL16K, AEItems.PORTABLE_ITEM_CELL64K, AEItems.PORTABLE_FLUID_CELL1K, AEItems.PORTABLE_FLUID_CELL4K, AEItems.PORTABLE_FLUID_CELL16K, AEItems.PORTABLE_FLUID_CELL64K});
        itemColors.m_92689_(BasicStorageCell::getColor, new ItemLike[]{AEItems.ITEM_CELL_1K, AEItems.ITEM_CELL_4K, AEItems.ITEM_CELL_16K, AEItems.ITEM_CELL_64K, AEItems.FLUID_CELL_1K, AEItems.FLUID_CELL_4K, AEItems.FLUID_CELL_16K, AEItems.FLUID_CELL_64K});
        for (ItemDefinition<?> definition : AEItems.getItems()) {
            Object item = definition.m_5456_();
            if (item instanceof PartItem) {
                AEColor color = AEColor.TRANSPARENT;
                if (item instanceof ColoredPartItem) {
                    color = ((ColoredPartItem)item).getColor();
                }
                itemColors.m_92689_((ItemColor)new StaticItemColor(color), new ItemLike[]{item});
                continue;
            }
            if (!(item instanceof PaintBallItem)) continue;
            InitItemColors.registerPaintBall(itemColors, (PaintBallItem)((Object)item));
        }
    }

    private static void registerPaintBall(ItemColors colors, PaintBallItem item) {
        int renderColor;
        AEColor color = item.getColor();
        int colorValue = item.isLumen() ? color.mediumVariant : color.mediumVariant;
        int r = colorValue >> 16 & 0xFF;
        int g = colorValue >> 8 & 0xFF;
        int b = colorValue & 0xFF;
        if (item.isLumen()) {
            float fail = 0.7f;
            int full = 76;
            renderColor = (int)(76.0f + (float)r * 0.7f) << 16 | (int)(76.0f + (float)g * 0.7f) << 8 | (int)(76.0f + (float)b * 0.7f) | 0xFF000000;
        } else {
            renderColor = r << 16 | g << 8 | b | 0xFF000000;
        }
        colors.m_92689_((is, tintIndex) -> renderColor, new ItemLike[]{item});
    }

    private static int getColorApplicatorColor(ItemStack itemStack, int idx) {
        if (idx == 0) {
            return -1;
        }
        AEColor col = ((ColorApplicatorItem)itemStack.m_41720_()).getActiveColor(itemStack);
        if (col == null) {
            return -1;
        }
        return switch (idx) {
            case 1 -> col.blackVariant;
            case 2 -> col.mediumVariant;
            case 3 -> col.whiteVariant;
            default -> -1;
        };
    }
}

