/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila;

import appeng.integration.modules.waila.BaseDataProvider;
import appeng.integration.modules.waila.tile.ChargerDataProvider;
import appeng.integration.modules.waila.tile.CraftingMonitorDataProvider;
import appeng.integration.modules.waila.tile.DebugDataProvider;
import appeng.integration.modules.waila.tile.GridNodeStateDataProvider;
import appeng.integration.modules.waila.tile.PowerStorageDataProvider;
import java.util.List;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class BlockEntityDataProvider
implements IComponentProvider,
IServerDataProvider<BlockEntity> {
    private final List<BaseDataProvider> providers = List.of(new ChargerDataProvider(), new PowerStorageDataProvider(), new GridNodeStateDataProvider(), new CraftingMonitorDataProvider(), new DebugDataProvider());

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        tooltip.remove(new ResourceLocation("minecraft:fe"));
        tooltip.remove(new ResourceLocation("minecraft:fluid"));
        for (BaseDataProvider provider : this.providers) {
            provider.appendTooltip(tooltip, accessor, config);
        }
    }

    public void appendServerData(CompoundTag tag, ServerPlayer player, Level level, BlockEntity blockEntity, boolean showDetails) {
        for (BaseDataProvider provider : this.providers) {
            provider.appendServerData(tag, player, level, blockEntity, showDetails);
        }
    }
}

