/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.util.AEColor;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.items.AEBaseItem;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MemoryCardItem
extends AEBaseItem
implements IMemoryCard {
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};

    public MemoryCardItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        String firstLineKey = this.getFirstValidTranslationKey(this.getSettingsName(stack) + ".name", this.getSettingsName(stack));
        lines.add((Component)Tooltips.of(new TranslatableComponent(firstLineKey)));
        CompoundTag data = this.getData(stack);
        if (data.m_128441_("tooltip")) {
            String tooltipKey = this.getFirstValidTranslationKey(data.m_128461_("tooltip") + ".name", data.m_128461_("tooltip"));
            lines.add((Component)Tooltips.of(new TranslatableComponent(tooltipKey)));
        }
        if (data.m_128441_("freq")) {
            short freq = data.m_128448_("freq");
            String freqTooltip = ChatFormatting.BOLD + Platform.p2p().toHexString(freq);
            lines.add((Component)Tooltips.of(new TranslatableComponent("gui.tooltips.ae2.P2PFrequency", new Object[]{freqTooltip})));
        }
    }

    private String getFirstValidTranslationKey(String ... name) {
        for (String n3 : name) {
            if (!I18n.m_118936_((String)n3)) continue;
            return n3;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String settingsName, CompoundTag data) {
        CompoundTag c = is.m_41784_();
        c.m_128359_("Config", settingsName);
        c.m_128365_("Data", (Tag)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        CompoundTag c = is.m_41784_();
        String name = c.m_128461_("Config");
        return name.isEmpty() ? GuiText.Blank.getTranslationKey() : name;
    }

    @Override
    public CompoundTag getData(ItemStack is) {
        CompoundTag c = is.m_41784_();
        CompoundTag o = c.m_128469_("Data");
        return o.m_6426_();
    }

    @Override
    public AEColor[] getColorCode(ItemStack is) {
        CompoundTag tag = this.getData(is);
        if (tag.m_128425_("colorCode", 11)) {
            int[] frequency = tag.m_128465_("colorCode");
            AEColor[] colorArray = AEColor.values();
            if (frequency.length == 8) {
                return new AEColor[]{colorArray[frequency[0]], colorArray[frequency[1]], colorArray[frequency[2]], colorArray[frequency[3]], colorArray[frequency[4]], colorArray[frequency[5]], colorArray[frequency[6]], colorArray[frequency[7]]};
            }
        }
        return DEFAULT_COLOR_CODE;
    }

    @Override
    public void notifyUser(Player player, MemoryCardMessages msg) {
        if (player.m_20193_().m_5776_()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.m_6352_((Component)PlayerMessages.SettingCleared.text(), Util.f_137441_);
                break;
            }
            case INVALID_MACHINE: {
                player.m_6352_((Component)PlayerMessages.InvalidMachine.text(), Util.f_137441_);
                break;
            }
            case SETTINGS_LOADED: {
                player.m_6352_((Component)PlayerMessages.LoadedSettings.text(), Util.f_137441_);
                break;
            }
            case SETTINGS_SAVED: {
                player.m_6352_((Component)PlayerMessages.SavedSettings.text(), Util.f_137441_);
                break;
            }
            case SETTINGS_RESET: {
                player.m_6352_((Component)PlayerMessages.ResetSettings.text(), Util.f_137441_);
                break;
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (InteractionUtil.isInAlternateUseMode(context.m_43723_())) {
            Level level = context.m_43725_();
            if (!level.m_5776_()) {
                this.clearCard(context.m_43723_(), context.m_43725_(), context.m_43724_());
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6225_(context);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (InteractionUtil.isInAlternateUseMode(player) && !level.f_46443_) {
            this.clearCard(player, level, hand);
        }
        return super.m_7203_(level, player, hand);
    }

    private void clearCard(Player player, Level level, InteractionHand hand) {
        IMemoryCard mem = (IMemoryCard)player.m_21120_(hand).m_41720_();
        mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
        player.m_21120_(hand).m_41751_(null);
    }
}

