/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu;

import appeng.menu.SlotSemantic;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SlotSemantics {
    private static final Map<String, SlotSemantic> REGISTRY = new ConcurrentHashMap<String, SlotSemantic>();
    public static final SlotSemantic STORAGE = SlotSemantics.register("STORAGE", false);
    public static final SlotSemantic PLAYER_INVENTORY = SlotSemantics.register("PLAYER_INVENTORY", true);
    public static final SlotSemantic PLAYER_HOTBAR = SlotSemantics.register("PLAYER_HOTBAR", true);
    public static final SlotSemantic TOOLBOX = SlotSemantics.register("TOOLBOX", true);
    public static final SlotSemantic CONFIG = SlotSemantics.register("CONFIG", false);
    public static final SlotSemantic UPGRADE = SlotSemantics.register("UPGRADE", false);
    public static final SlotSemantic STORAGE_CELL = SlotSemantics.register("STORAGE_CELL", false);
    public static final SlotSemantic INSCRIBER_PLATE_TOP = SlotSemantics.register("INSCRIBER_PLATE_TOP", false);
    public static final SlotSemantic INSCRIBER_PLATE_BOTTOM = SlotSemantics.register("INSCRIBER_PLATE_BOTTOM", false);
    public static final SlotSemantic MACHINE_INPUT = SlotSemantics.register("MACHINE_INPUT", false);
    public static final SlotSemantic MACHINE_OUTPUT = SlotSemantics.register("MACHINE_OUTPUT", false);
    public static final SlotSemantic MACHINE_CRAFTING_GRID = SlotSemantics.register("MACHINE_CRAFTING_GRID", false);
    public static final SlotSemantic BLANK_PATTERN = SlotSemantics.register("BLANK_PATTERN", false);
    public static final SlotSemantic ENCODED_PATTERN = SlotSemantics.register("ENCODED_PATTERN", false);
    public static final SlotSemantic VIEW_CELL = SlotSemantics.register("VIEW_CELL", false);
    public static final SlotSemantic CRAFTING_GRID = SlotSemantics.register("CRAFTING_GRID", false);
    public static final SlotSemantic PROCESSING_INPUTS = SlotSemantics.register("PROCESSING_INPUTS", false);
    public static final SlotSemantic PROCESSING_OUTPUTS = SlotSemantics.register("PROCESSING_OUTPUTS", false);
    public static final SlotSemantic CRAFTING_RESULT = SlotSemantics.register("CRAFTING_RESULT", false);
    public static final SlotSemantic BIOMETRIC_CARD = SlotSemantics.register("BIOMETRIC_CARD", false);

    private SlotSemantics() {
    }

    public static SlotSemantic register(String id, boolean playerSide) {
        SlotSemantic semantic = new SlotSemantic(id, playerSide);
        SlotSemantic existing = REGISTRY.putIfAbsent(semantic.id(), semantic);
        if (existing != null) {
            throw new IllegalArgumentException("Semantic with id " + semantic.id() + "was already registered");
        }
        return semantic;
    }

    public static SlotSemantic getOrThrow(String key) {
        SlotSemantic semantic = REGISTRY.get(key);
        if (semantic == null) {
            throw new IllegalArgumentException("Unknown slot semantic: " + key);
        }
        return semantic;
    }
}

