/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeyFilter;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.me.helpers.BaseActionSource;
import appeng.util.ConfigMenuInventory;
import com.google.common.base.Preconditions;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class ConfigInventory
extends GenericStackInv {
    protected ConfigInventory(@Nullable AEKeyFilter filter, GenericStackInv.Mode mode, int size, @Nullable Runnable listener) {
        super(listener, mode, size);
        this.setFilter(filter);
    }

    public static ConfigInventory configTypes(int size, @Nullable Runnable changeListener) {
        return new ConfigInventory(null, GenericStackInv.Mode.CONFIG_TYPES, size, changeListener);
    }

    public static ConfigInventory configTypes(@Nullable AEKeyFilter filter, int size, @Nullable Runnable changeListener) {
        return new ConfigInventory(filter, GenericStackInv.Mode.CONFIG_TYPES, size, changeListener);
    }

    public static ConfigInventory configStacks(@Nullable AEKeyFilter filter, int size, @Nullable Runnable changeListener) {
        return new ConfigInventory(filter, GenericStackInv.Mode.CONFIG_STACKS, size, changeListener);
    }

    public static ConfigInventory storage(int size, @Nullable Runnable changeListener) {
        return new ConfigInventory(null, GenericStackInv.Mode.STORAGE, size, changeListener);
    }

    public static ConfigInventory storage(@Nullable AEKeyFilter filter, int size, @Nullable Runnable changeListener) {
        return new ConfigInventory(filter, GenericStackInv.Mode.STORAGE, size, changeListener);
    }

    @Override
    @Nullable
    public GenericStack getStack(int slot) {
        GenericStack stack = super.getStack(slot);
        if (stack != null && !this.isAllowed(stack.what())) {
            this.setStack(slot, null);
            stack = null;
        }
        return stack;
    }

    @Override
    @Nullable
    public AEKey getKey(int slot) {
        AEKey key = super.getKey(slot);
        if (key == null) {
            return null;
        }
        if (!this.isAllowed(key)) {
            this.setStack(slot, null);
            key = null;
        }
        return key;
    }

    public Set<AEKey> keySet() {
        LinkedHashSet<AEKey> result = new LinkedHashSet<AEKey>();
        for (int i = 0; i < this.stacks.length; ++i) {
            AEKey what = this.getKey(i);
            if (what == null) continue;
            result.add(what);
        }
        return result;
    }

    @Override
    public void setStack(int slot, @Nullable GenericStack stack) {
        if (stack != null && !this.isAllowed(stack.what())) {
            return;
        }
        if (stack != null) {
            boolean typesOnly;
            boolean bl = typesOnly = this.mode == GenericStackInv.Mode.CONFIG_TYPES;
            if (typesOnly && stack.amount() != 0L) {
                stack = new GenericStack(stack.what(), 0L);
            } else if (!typesOnly && stack.amount() <= 0L) {
                stack = null;
            }
        }
        super.setStack(slot, stack);
    }

    @Override
    public ConfigMenuInventory createMenuWrapper() {
        return new ConfigMenuInventory(this);
    }

    public void addFilter(ItemLike item) {
        this.addFilter(AEItemKey.of(item));
    }

    public void addFilter(Fluid fluid) {
        this.addFilter(AEFluidKey.of(fluid));
    }

    public void addFilter(AEKey what) {
        Preconditions.checkState((this.getMode() == GenericStackInv.Mode.CONFIG_TYPES ? 1 : 0) != 0);
        this.insert(what, 1L, Actionable.MODULATE, new BaseActionSource());
    }
}

