/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.block.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class IItemHandlerTEBase
extends BlockEntity
implements Nameable {
    private Component customName;
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createItemHandler);

    public IItemHandlerTEBase(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    @Nonnull
    protected abstract IItemHandler createItemHandler();

    public void m_142466_(@Nonnull CompoundTag tag) {
        CompoundTag invTag = tag.m_128469_("inv");
        this.handler.ifPresent(stack -> ((INBTSerializable)stack).deserializeNBT((Tag)invTag));
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        super.m_142466_(tag);
    }

    public void m_183515_(@Nonnull CompoundTag tag) {
        this.handler.ifPresent(stack -> {
            CompoundTag compound = (CompoundTag)((INBTSerializable)stack).serializeNBT();
            tag.m_128365_("inv", (Tag)compound);
        });
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        super.m_183515_(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.handler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handler = LazyOptional.of(this::createItemHandler);
    }

    @Nonnull
    public Component m_7755_() {
        return this.customName != null ? this.customName : new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    @Nonnull
    public Component m_5446_() {
        return this.m_7755_();
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }
}

