/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.compat.jei.reprocessor;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonIcons;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.GenericDeviceBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.Orientation;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.compat.jei.AbstractModRecipeCategory;
import it.zerono.mods.zerocore.lib.compat.jei.drawable.ProgressBarDrawable;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.ItemStackRecipeResult;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public class ReprocessorRecipeCategory
extends AbstractModRecipeCategory<ReprocessorRecipe> {
    private final Rectangle _powerBarArea = new Rectangle(6, 23, 16, 64);
    private final Rectangle _fluidBarrArea = new Rectangle(34, 23, 16, 64);
    private final IGuiHelper _guiHelper;
    private final ProgressBarDrawable _powerBar;
    private List<Component> _powerBarTooltips;
    private ProgressBarDrawable _fluidBar;
    private List<Component> _fluidBarTooltips = this._powerBarTooltips = ObjectLists.emptyList();
    private IDrawableAnimated _progressBar;
    private FluidStack _recipeFluid;
    private ISprite _recipeFluidSprite;
    private ISprite _recipeProgressSprite;

    public ReprocessorRecipeCategory(IGuiHelper guiHelper) {
        super(ReprocessorRecipe.ID, (Component)new TranslatableComponent("compat.bigreactors.jei.reprocessor.recipecategory.title"), ((GenericDeviceBlock)((Object)Content.Blocks.REPROCESSOR_WASTEINJECTOR.get())).createItemStack(), guiHelper, (IDrawable)guiHelper.drawableBuilder(ExtremeReactors.newID("textures/gui/jei/reprocessor.png"), 0, 0, 96, 96).setTextureSize(96, 96).addPadding(5, 5, 5, 78).build());
        this._guiHelper = guiHelper;
        this._powerBar = new ProgressBarDrawable((NonNullSupplier)CommonIcons.PowerBar, 0, Padding.ZERO, this._powerBarArea.Width, this._powerBarArea.Height, Orientation.BottomToTop);
    }

    public Class<? extends ReprocessorRecipe> getRecipeClass() {
        return ReprocessorRecipe.class;
    }

    public void setIngredients(ReprocessorRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients((List)recipe.m_7527_());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)((ItemStackRecipeResult)recipe.getResult()).getResult());
        this._recipeFluid = ((FluidStackRecipeIngredient)recipe.getIngredient2()).getMatchingElements().stream().filter(Objects::nonNull).filter(fs -> !fs.isEmpty()).findAny().orElse(FluidStack.EMPTY);
        if (!this._recipeFluid.isEmpty()) {
            this._recipeFluidSprite = ModRenderHelper.getFlowingFluidSprite((Fluid)this._recipeFluid.getFluid());
            this._recipeProgressSprite = this._recipeFluidSprite.copyWith(CommonIcons.ReprocessorProgressBarMask.get());
            this._fluidBar = new ProgressBarDrawable(this::getRecipeFluidSprite, 0, Padding.ZERO, 16, 64, Orientation.BottomToTop);
            this._fluidBar.setTint(Colour.fromARGB((int)this._recipeFluid.getFluid().getAttributes().getColor()));
            this._fluidBar.setProgress(5000.0, (double)this._recipeFluid.getAmount());
            this._fluidBarTooltips = new ObjectArrayList(3);
            this._fluidBarTooltips.add((Component)ReprocessorRecipeCategory.getFluidName(this._recipeFluid.getFluid()).m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE));
            this._fluidBarTooltips.add(CodeHelper.TEXT_EMPTY_LINE);
            this._fluidBarTooltips.add((Component)new TextComponent(String.format("%d mB", this._recipeFluid.getAmount())).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
            this._progressBar = null;
        } else {
            this._recipeFluidSprite = this._recipeProgressSprite = Sprite.EMPTY;
            this._progressBar = null;
            this._fluidBar = ProgressBarDrawable.empty();
        }
        this._powerBar.setProgress(5000.0, 1000.0);
        this._powerBarTooltips = new ObjectArrayList(3);
        this._powerBarTooltips.add((Component)new TranslatableComponent("compat.bigreactors.jei.common.recipecategory.energy.tooltip.title").m_6270_(CommonConstants.STYLE_TOOLTIP_TITLE));
        this._powerBarTooltips.add(CodeHelper.TEXT_EMPTY_LINE);
        this._powerBarTooltips.add((Component)new TextComponent(String.format("%d FE", 1000)).m_6270_(CommonConstants.STYLE_TOOLTIP_VALUE));
    }

    public void setRecipe(IRecipeLayout layout, ReprocessorRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        stacks.init(0, true, 83, 5);
        stacks.set(ingredients);
        stacks.init(1, false, 83, 70);
        stacks.set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void draw(ReprocessorRecipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        this._powerBar.draw(matrix, this._powerBarArea.getX1(), this._powerBarArea.getY1());
        this._fluidBar.draw(matrix, this._fluidBarrArea.getX1(), this._fluidBarrArea.getY1());
        if (null != this._progressBar) {
            this._progressBar.draw(matrix, 84, 31);
        }
    }

    public List<Component> getTooltipStrings(ReprocessorRecipe recipe, double mouseX, double mouseY) {
        if (this._powerBarArea.contains(mouseX, mouseY)) {
            return this._powerBarTooltips;
        }
        if (this._fluidBarrArea.contains(mouseX, mouseY)) {
            return this._fluidBarTooltips;
        }
        return ObjectLists.emptyList();
    }

    private ISprite getRecipeFluidSprite() {
        return this._recipeFluidSprite;
    }

    private static BaseComponent getFluidName(Fluid fluid) {
        return new TranslatableComponent(fluid.getAttributes().getTranslationKey());
    }
}

