/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.IIOPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.IFluidPort;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.IPowerTap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergyBuffer;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyProvider;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class AbstractGeneratorMultiblockController<Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant>
extends AbstractMultiblockController<Controller, V>
implements IWideEnergyProvider {
    protected static final EnergySystem INTERNAL_ENERGY_SYSTEM = EnergySystem.ForgeEnergy;
    private final EnergyBuffer _energyBuffer = new EnergyBuffer(INTERNAL_ENERGY_SYSTEM, 0.0);
    private EnergySystem _outputEnergySystem = INTERNAL_ENERGY_SYSTEM;

    public AbstractGeneratorMultiblockController(Level world) {
        super(world);
        this.setInteriorInvisible(false);
    }

    protected EnergyBuffer getEnergyBuffer() {
        return this._energyBuffer;
    }

    public EnergySystem getOutputEnergySystem() {
        return this._outputEnergySystem;
    }

    protected void setOutputEnergySystem(EnergySystem system) {
        this._outputEnergySystem = system;
    }

    public double getEnergyStoredPercentage() {
        return this.getEnergyStored(INTERNAL_ENERGY_SYSTEM, null) / this.getCapacity(INTERNAL_ENERGY_SYSTEM, null);
    }

    protected static double distributeEnergyEqually(double energyAmount, Collection<? extends IPowerTap> powerTaps) {
        if (energyAmount <= 0.0 || powerTaps.isEmpty()) {
            return 0.0;
        }
        double energyPerTap = energyAmount / (double)powerTaps.size();
        return powerTaps.stream().map(IPowerTap::getPowerTapHandler).filter(IIOPortHandler::isActive).filter(IIOPortHandler::isConnected).mapToDouble(handler -> handler.outputEnergy(energyPerTap)).sum();
    }

    public abstract Optional<IFluidHandler> getLiquidHandler();

    public abstract Optional<IFluidHandler> getGasHandler();

    public abstract Optional<IFluidHandler> getFluidHandler(IoDirection var1);

    protected static <Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant> int distributeFluidEqually(FluidStack availableFluid, Collection<? extends IFluidPort<Controller, V>> coolantPorts) {
        if (availableFluid.isEmpty() || coolantPorts.isEmpty()) {
            return 0;
        }
        int fluidPerPort = availableFluid.getAmount() / coolantPorts.size();
        return coolantPorts.stream().filter(p -> p.getIoDirection().isOutput()).map(IFluidPort::getFluidPortHandler).filter(IIOPortHandler::isActive).filter(IIOPortHandler::isConnected).mapToInt(handler -> handler.outputFluid(new FluidStack(availableFluid, fluidPerPort))).sum();
    }

    protected static <Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant> int acquireFluidEqually(IFluidHandler destination, int maxAmount, Collection<? extends IFluidPort<Controller, V>> coolantPorts) {
        if (maxAmount <= 0 || coolantPorts.isEmpty()) {
            return 0;
        }
        int fluidPerPort = maxAmount / coolantPorts.size();
        return coolantPorts.stream().filter(p -> p.getIoDirection().isInput()).map(IFluidPort::getFluidPortHandler).filter(IIOPortHandler::isActive).filter(IIOPortHandler::isConnected).mapToInt(handler -> handler.inputFluid(destination, fluidPerPort)).sum();
    }

    public double extractEnergy(EnergySystem system, @Nullable Direction from, double maxAmount, boolean simulate) {
        return this.getEnergyBuffer().extractEnergy(system, maxAmount, simulate);
    }

    public double getEnergyStored(EnergySystem system, @Nullable Direction from) {
        return this.getEnergyBuffer().getEnergyStored(system);
    }

    public double getCapacity(EnergySystem system, @Nullable Direction from) {
        return this.getEnergyBuffer().getCapacity(system);
    }

    public EnergySystem getEnergySystem() {
        return this.getEnergyBuffer().getEnergySystem();
    }

    public boolean canConnectEnergy(EnergySystem system, @Nullable Direction from) {
        return true;
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        this.syncChildDataEntityFrom((ISyncableEntity)this.getEnergyBuffer(), "buffer", data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            this.setOutputEnergySystem(EnergySystem.read((CompoundTag)data, (String)"energySystem", (EnergySystem)EnergySystem.REFERENCE));
        }
        super.syncDataFrom(data, syncReason);
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        this.syncChildDataEntityTo((ISyncableEntity)this.getEnergyBuffer(), "buffer", data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            EnergySystem.write((CompoundTag)data, (String)"energySystem", (EnergySystem)this.getOutputEnergySystem());
        }
        return data;
    }
}

