/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.chargingport;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.AbstractPowerTapHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.chargingport.IChargingPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockVariantProvider;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.handler.TileEntityItemStackHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractChargingPortHandler<Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant, T extends AbstractMultiblockEntity<Controller>>
extends AbstractPowerTapHandler<Controller, V, T>
implements IChargingPortHandler,
ISyncableEntity {
    public static String TILE_COMMAND_EJECT = "eject";
    private final ItemStackHandler _input;
    private final ItemStackHandler _output;
    private double _chargingRate;

    protected AbstractChargingPortHandler(EnergySystem energySystem, T part) {
        super(energySystem, part, IoMode.Active);
        this._input = new TileEntityItemStackHandler(part, 1);
        this._output = new TileEntityItemStackHandler(part, 1);
        this._chargingRate = 0.0;
    }

    protected double getChargingRate() {
        if (0.0 == this._chargingRate) {
            this._chargingRate = ((IMultiblockVariantProvider)this.getPart()).getMultiblockVariant().map(IMultiblockGeneratorVariant::getChargerMaxRate).orElse(0.0);
        }
        return this._chargingRate;
    }

    protected <T> LazyOptional<T> getCapabilityFromInventory(Capability<T> capability, boolean ejectIfNotFound) {
        ItemStack stack = this._input.getStackInSlot(0);
        if (!stack.m_41619_()) {
            LazyOptional cap = stack.getCapability(capability, null);
            if (ejectIfNotFound && !cap.isPresent()) {
                this.onChargeComplete();
            }
            return cap;
        }
        return LazyOptional.empty();
    }

    protected void onChargeComplete() {
        if (this._output.getStackInSlot(0).m_41619_()) {
            this._output.setStackInSlot(0, this._input.getStackInSlot(0));
            this._input.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    @Override
    public IItemHandlerModifiable getItemStackHandler(IoDirection direction) {
        return direction.isInput() ? this._input : this._output;
    }

    @Override
    public void eject() {
        this.onChargeComplete();
    }

    @Override
    public boolean isConnected() {
        return !this._input.getStackInSlot(0).m_41619_();
    }

    @Override
    public void checkConnections(@Nullable Level world, BlockPos position) {
    }

    @Override
    public void invalidate() {
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvFrom(data, "in", this._input);
            AbstractChargingPortHandler.syncInvFrom(data, "out", this._output);
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvTo(data, "in", this._input);
            AbstractChargingPortHandler.syncInvTo(data, "out", this._output);
        }
        return data;
    }

    private static void syncInvTo(CompoundTag data, String name, ItemStackHandler inv) {
        if (!inv.getStackInSlot(0).m_41619_()) {
            data.m_128365_(name, (Tag)inv.serializeNBT());
        }
    }

    private static void syncInvFrom(CompoundTag data, String name, ItemStackHandler inv) {
        if (data.m_128441_(name)) {
            inv.deserializeNBT(data.m_128469_(name));
        }
    }
}

