/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.chargingport;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.powertap.chargingport.AbstractChargingPortHandler;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.energy.IEnergyStorage;

public class ChargingPortHandlerFE<Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant, T extends AbstractMultiblockEntity<Controller>>
extends AbstractChargingPortHandler<Controller, V, T> {
    private static Capability<IEnergyStorage> CAPAP_FORGE_ENERGYSTORAGE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IEnergyStorage>(){});

    public ChargingPortHandlerFE(T part) {
        super(EnergySystem.ForgeEnergy, part);
    }

    @Override
    public double outputEnergy(double amount) {
        int transfer = (int)Math.min(amount, this.getChargingRate());
        double used = this.getCapabilityFromInventory(CAPAP_FORGE_ENERGYSTORAGE, true).map(cap -> ChargingPortHandlerFE.recharge(cap, transfer)).orElse(amount);
        if (used == 0.0) {
            this.onChargeComplete();
        }
        return used;
    }

    private static int recharge(IEnergyStorage cap, int energyAmount) {
        return cap.canReceive() ? cap.receiveEnergy(energyAmount, false) : 0;
    }
}

