/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.FluidizerRecipeHolder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.IFluidizerRecipeHolder;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerFluidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerOutputPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerPowerPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerSolidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IActivableMachine;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.TickerListener;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergyHelper;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage2;
import it.zerono.mods.zerocore.lib.energy.WideEnergyBuffer;
import it.zerono.mods.zerocore.lib.energy.handler.WideEnergyStoragePolicyWrapper;
import it.zerono.mods.zerocore.lib.fluid.FluidTank;
import it.zerono.mods.zerocore.lib.fluid.handler.FluidHandlerPolicyWrapper;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockMachine;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.storage.collection.IPartCollection;
import it.zerono.mods.zerocore.lib.multiblock.storage.collection.PartCollection;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.recipe.holder.IHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import it.zerono.mods.zerocore.lib.recipe.result.RecipeResultTargetWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.LogicalSide;

public class MultiblockFluidizer
extends AbstractCuboidMultiblockController<MultiblockFluidizer>
implements IMultiblockMachine,
IActivableMachine,
ISyncableEntity,
IDebuggable,
IFluidizerRecipeHolder.Callbacks {
    public static final WideAmount ENERGY_CAPACITY = WideAmount.asImmutable((long)50000L);
    private final FluidTank _outputTank = new FluidTank(0);
    private final WideEnergyBuffer _energyBuffer;
    private final IFluidHandler _outputFluidHandler = FluidHandlerPolicyWrapper.outputOnly((IFluidHandler)this._outputTank);
    private final IWideEnergyStorage2 _energyInputHandler;
    private final IPartCollection<MultiblockFluidizer, FluidizerSolidInjectorEntity> _solidInjectors;
    private final IPartCollection<MultiblockFluidizer, FluidizerFluidInjectorEntity> _fluidInjectors;
    private final ObjectList<IRecipeIngredientSource<ItemStack>> _solidSources;
    private final ObjectList<IRecipeIngredientSource<FluidStack>> _fluidSources;
    private final IRecipeResultTarget<FluidStackRecipeResult> _fluidTarget;
    private IFluidizerRecipeHolder _recipeHolder;
    private boolean _ingredientsChanged = false;
    private final TickerListener _ticker;
    private boolean _active = false;
    private boolean _interiorInvisible = false;

    public MultiblockFluidizer(Level world) {
        super(world);
        this._energyBuffer = new WideEnergyBuffer(EnergySystem.ForgeEnergy, ENERGY_CAPACITY, WideAmount.asImmutable((long)1000L));
        this._energyInputHandler = WideEnergyStoragePolicyWrapper.inputOnly((IWideEnergyStorage2)this._energyBuffer);
        this._solidInjectors = new PartCollection(2, p -> p instanceof FluidizerSolidInjectorEntity);
        this._fluidInjectors = new PartCollection(2, p -> p instanceof FluidizerFluidInjectorEntity);
        this._solidSources = new ObjectArrayList(2);
        this._fluidSources = new ObjectArrayList(2);
        this._fluidTarget = RecipeResultTargetWrapper.wrap((IFluidHandler)this._outputTank);
        this._ticker = TickerListener.singleListener((int)10, () -> ((MultiblockFluidizer)this).sendUpdates());
    }

    public IFluidHandler getFluidHandler() {
        return this._outputFluidHandler;
    }

    public IWideEnergyStorage2 getEnergyStorage() {
        return this._energyInputHandler;
    }

    public List<FluidizerSolidInjectorEntity> getSolidInjectors() {
        return this._solidInjectors.asList();
    }

    public List<FluidizerFluidInjectorEntity> getFluidInjectors() {
        return this._fluidInjectors.asList();
    }

    public IFluidizerRecipe.Type getRecipeType() {
        return null != this._recipeHolder ? this._recipeHolder.getRecipeType() : IFluidizerRecipe.Type.Invalid;
    }

    public double getRecipeProgress() {
        return null != this._recipeHolder ? this._recipeHolder.getProgress() : 0.0;
    }

    public void onIngredientsChanged() {
        if (this.calledByLogicalServer()) {
            this._ingredientsChanged = true;
        }
    }

    public boolean isInteriorInvisible() {
        return this._interiorInvisible;
    }

    public boolean isInteriorVisible() {
        return !this._interiorInvisible;
    }

    protected void setInteriorInvisible(boolean visible) {
        this._interiorInvisible = visible;
    }

    @Override
    public boolean canProcessRecipe(IFluidizerRecipe recipe) {
        return this.isMachineActive() && this._energyBuffer.getEnergyStored().intValue() >= (Integer)Config.COMMON.fluidizer.energyPerRecipeTick.get() && this._fluidTarget.countStorableResults((IRecipeResult)recipe.getResult()) > 0L;
    }

    @Override
    public boolean hasIngredientsChanged() {
        boolean v = this._ingredientsChanged;
        this._ingredientsChanged = false;
        return v;
    }

    @Override
    public void onRecipeTickProcessed(int currentTick) {
        this._energyBuffer.extractEnergy(EnergySystem.ForgeEnergy, WideAmount.from((long)((long)((Integer)Config.COMMON.fluidizer.energyPerRecipeTick.get()).intValue() * (long)this._recipeHolder.getEnergyUsageMultiplier())), OperationMode.Execute);
    }

    @Override
    public void onRecipeChanged(IFluidizerRecipe recipe) {
    }

    public boolean isMachineActive() {
        return this._active;
    }

    public void setMachineActive(boolean active) {
        if (this.isMachineActive() == active) {
            return;
        }
        this._active = active;
        if (active) {
            this.getConnectedParts().forEach(IMultiblockPart::onMachineActivated);
        } else {
            this.getConnectedParts().forEach(IMultiblockPart::onMachineDeactivated);
        }
        this.callOnLogicalServer(() -> this.markReferenceCoordForUpdate());
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.syncBooleanElementFrom("active", data, b -> {
            this._active = b;
        });
        this.syncChildDataEntityFrom((ISyncableEntity)this._outputTank, "out", data, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._energyBuffer, "energy", data, syncReason);
        if (null != this._recipeHolder) {
            this._recipeHolder.refresh();
            this.syncChildDataEntityFrom(this._recipeHolder, "recipe", data, syncReason);
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        this.syncBooleanElementTo("active", data, this.isMachineActive());
        this.syncChildDataEntityTo((ISyncableEntity)this._outputTank, "out", data, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._energyBuffer, "energy", data, syncReason);
        if (null != this._recipeHolder) {
            this.syncChildDataEntityTo(this._recipeHolder, "recipe", data, syncReason);
        }
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        if (!this.isAssembled()) {
            return;
        }
        messages.add(side, (IDebuggable)this._energyBuffer, "Energy buffer:");
        messages.add(side, (IDebuggable)this._outputTank, "Output tank:");
        messages.addUnlocalized("Current tick %d", new Object[]{this._recipeHolder.getCurrentTick()});
    }

    protected boolean updateServer() {
        ProfilerFiller profiler = this.getWorld().m_46473_();
        boolean updated = false;
        profiler.m_6180_("Extreme Reactors|Fluidizer update");
        profiler.m_6180_("Process");
        if (this.isMachineActive()) {
            updated = this._recipeHolder.processRecipe();
        }
        profiler.m_6182_("Updates");
        this._ticker.tick();
        profiler.m_7238_();
        profiler.m_7238_();
        return updated;
    }

    protected void updateClient() {
    }

    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (!super.isMachineWhole(validatorCallback)) {
            return false;
        }
        if (1 != this.getPartsCount(p -> p instanceof FluidizerControllerEntity)) {
            validatorCallback.setLastError("multiblock.validation.fluidizer.missing_controller", new Object[0]);
            return false;
        }
        int solidInjectors = this.getPartsCount(p -> p instanceof FluidizerSolidInjectorEntity);
        int fluidInjectors = this.getPartsCount(p -> p instanceof FluidizerFluidInjectorEntity);
        if (0 == solidInjectors && fluidInjectors < 2 || solidInjectors > 0 && fluidInjectors > 0 || solidInjectors > 2 || fluidInjectors > 2) {
            validatorCallback.setLastError("multiblock.validation.fluidizer.invalid_injectors", new Object[0]);
            return false;
        }
        if (this.getPartsCount(p -> p instanceof FluidizerOutputPortEntity) < 1) {
            validatorCallback.setLastError("multiblock.validation.fluidizer.missing_outputport", new Object[0]);
            return false;
        }
        if (this.getPartsCount(p -> p instanceof FluidizerPowerPortEntity) < 1) {
            validatorCallback.setLastError("multiblock.validation.fluidizer.missing_powerport", new Object[0]);
            return false;
        }
        return true;
    }

    protected void onPartAdded(IMultiblockPart<MultiblockFluidizer> newPart) {
        if (this._solidInjectors.test(newPart)) {
            this._solidInjectors.add(newPart);
        } else if (this._fluidInjectors.test(newPart)) {
            this._fluidInjectors.add(newPart);
        }
    }

    protected void onPartRemoved(IMultiblockPart<MultiblockFluidizer> oldPart) {
        if (this._solidInjectors.test(oldPart)) {
            this._solidInjectors.remove(oldPart);
        } else if (this._fluidInjectors.test(oldPart)) {
            this._fluidInjectors.remove(oldPart);
        }
    }

    protected void onMachineAssembled() {
        this._solidSources.clear();
        this._solidInjectors.stream().map(FluidizerSolidInjectorEntity::asRecipeSource).forEach(arg_0 -> this._solidSources.add(arg_0));
        this._fluidSources.clear();
        this._fluidInjectors.stream().map(FluidizerFluidInjectorEntity::asRecipeSource).forEach(arg_0 -> this._fluidSources.add(arg_0));
        int solidInjectors = this.getPartsCount(p -> p instanceof FluidizerSolidInjectorEntity);
        int fluidInjectors = this.getPartsCount(p -> p instanceof FluidizerFluidInjectorEntity);
        if (1 == solidInjectors) {
            this._recipeHolder = FluidizerRecipeHolder.solid(this, this::solidRecipeFactory);
        } else if (2 == solidInjectors) {
            this._recipeHolder = FluidizerRecipeHolder.solidMixing(this, this::solidMixingRecipeFactory);
        } else if (2 == fluidInjectors) {
            this._recipeHolder = FluidizerRecipeHolder.fluidMixing(this, this::solidFluidMixingFactory);
        } else {
            throw new IllegalStateException("Invalid number of injectors");
        }
        this._outputTank.setCapacity(this.getBoundingBox().getInternalVolume() * 4000);
        this.setInteriorInvisible(!this.isAnyPartConnected(part -> part instanceof FluidizerGlassEntity));
        this.callOnLogicalSide(() -> this.markReferenceCoordForUpdate(), () -> this.markMultiblockForRenderUpdate());
        super.onMachineAssembled();
    }

    protected void onMachineRestored() {
        this.onMachineAssembled();
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
        this._active = false;
        this.markMultiblockForRenderUpdate();
    }

    protected int getMinimumNumberOfPartsForAssembledMachine() {
        return 26;
    }

    protected int getMaximumXSize() {
        return (Integer)Config.COMMON.fluidizer.maxFluidizerSize.get();
    }

    protected int getMinimumXSize() {
        return 3;
    }

    protected int getMaximumZSize() {
        return (Integer)Config.COMMON.fluidizer.maxFluidizerSize.get();
    }

    protected int getMinimumZSize() {
        return 3;
    }

    protected int getMaximumYSize() {
        return (Integer)Config.COMMON.fluidizer.maxFluidizerHeight.get();
    }

    protected int getMinimumYSize() {
        return 3;
    }

    protected void onAssimilate(IMultiblockController<MultiblockFluidizer> assimilated) {
        if (!(assimilated instanceof MultiblockFluidizer)) {
            Log.LOGGER.warn(Log.FLUIDIZER, "[{}] Fluidizer @ {} is attempting to assimilate a non-Fluidizer machine! That machine's data will be lost!", (Object)CodeHelper.getWorldSideName((Level)this.getWorld()), (Object)this.getReferenceCoord());
            return;
        }
        MultiblockFluidizer otherFluidizer = (MultiblockFluidizer)assimilated;
        FluidUtil.tryFluidTransfer((IFluidHandler)this._outputTank, (IFluidHandler)otherFluidizer._outputTank, (int)Integer.MAX_VALUE, (boolean)true);
        EnergyHelper.transferEnergy((IWideEnergyStorage2)this._energyBuffer, (IWideEnergyStorage2)otherFluidizer._energyBuffer, (WideAmount)WideAmount.MAX_VALUE, (OperationMode)OperationMode.Execute);
    }

    protected void onAssimilated(IMultiblockController<MultiblockFluidizer> assimilator) {
        this._solidInjectors.clear();
        this._fluidInjectors.clear();
    }

    protected boolean isBlockGoodForFrame(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockFluidizer.notifyInvalidBlock(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForTop(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockFluidizer.notifyInvalidBlock(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForBottom(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockFluidizer.notifyInvalidBlock(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForSides(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockFluidizer.notifyInvalidBlock(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForInterior(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        if (world.m_8055_(new BlockPos(x, y, z)).m_60795_()) {
            return true;
        }
        MultiblockFluidizer.notifyInvalidBlock(world, x, y, z, validatorCallback);
        return false;
    }

    private static boolean notifyInvalidBlock(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        validatorCallback.setLastError(position, "multiblock.validation.fluidizer.invalid_block", new Object[]{ModBlock.getNameForTranslation((Block)world.m_8055_(position).m_60734_())});
        return false;
    }

    @Nullable
    private IHeldRecipe<FluidizerSolidRecipe> solidRecipeFactory(IRecipeHolder<FluidizerSolidRecipe> holder) {
        this._ingredientsChanged = false;
        IRecipeIngredientSource source = (IRecipeIngredientSource)this._solidSources.get(0);
        return Content.Recipes.FLUIDIZER_RECIPE_TYPE.findFirst(recipe -> FluidizerSolidRecipe.lookup(recipe, (IRecipeIngredientSource<ItemStack>)source)).map(recipe -> (FluidizerSolidRecipe)recipe).map(recipe -> new FluidizerSolidRecipe.HeldRecipe((FluidizerSolidRecipe)recipe, holder, (IRecipeIngredientSource<ItemStack>)source, this._fluidTarget)).orElse(null);
    }

    @Nullable
    private IHeldRecipe<FluidizerSolidMixingRecipe> solidMixingRecipeFactory(IRecipeHolder<FluidizerSolidMixingRecipe> holder) {
        this._ingredientsChanged = false;
        IRecipeIngredientSource source1 = (IRecipeIngredientSource)this._solidSources.get(0);
        IRecipeIngredientSource source2 = (IRecipeIngredientSource)this._solidSources.get(1);
        return Content.Recipes.FLUIDIZER_RECIPE_TYPE.findFirst(recipe -> FluidizerSolidMixingRecipe.lookup(recipe, (IRecipeIngredientSource<ItemStack>)source1, (IRecipeIngredientSource<ItemStack>)source2)).map(recipe -> (FluidizerSolidMixingRecipe)recipe).map(recipe -> new FluidizerSolidMixingRecipe.HeldRecipe((FluidizerSolidMixingRecipe)recipe, holder, (IRecipeIngredientSource<ItemStack>)source1, (IRecipeIngredientSource<ItemStack>)source2, this._fluidTarget)).orElse(null);
    }

    @Nullable
    private IHeldRecipe<FluidizerFluidMixingRecipe> solidFluidMixingFactory(IRecipeHolder<FluidizerFluidMixingRecipe> holder) {
        this._ingredientsChanged = false;
        IRecipeIngredientSource source1 = (IRecipeIngredientSource)this._fluidSources.get(0);
        IRecipeIngredientSource source2 = (IRecipeIngredientSource)this._fluidSources.get(1);
        return Content.Recipes.FLUIDIZER_RECIPE_TYPE.findFirst(recipe -> FluidizerFluidMixingRecipe.lookup(recipe, (IRecipeIngredientSource<FluidStack>)source1, (IRecipeIngredientSource<FluidStack>)source2)).map(recipe -> (FluidizerFluidMixingRecipe)recipe).map(recipe -> new FluidizerFluidMixingRecipe.HeldRecipe((FluidizerFluidMixingRecipe)recipe, holder, (IRecipeIngredientSource<FluidStack>)source1, (IRecipeIngredientSource<FluidStack>)source2, this._fluidTarget)).orElse(null);
    }
}

