/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.AbstractReprocessorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.Ticker;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.ItemStackRecipeResult;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ReprocessorCollectorEntity
extends AbstractReprocessorEntity {
    private AABB _renderBoundingBox = CodeHelper.EMPTY_AABB;
    private Ticker _tersTicker;
    private ItemStack _recipeSourceItem = this._recipeProductItem = ItemStack.f_41583_;
    private ItemStack _recipeProductItem;

    public ReprocessorCollectorEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.REPROCESSOR_COLLECTOR.get(), position, blockState);
    }

    public void onRecipeChanged(@Nullable ReprocessorRecipe currentRecipe) {
        if (null != currentRecipe) {
            List ingredients = ((ItemStackRecipeIngredient)currentRecipe.getIngredient1()).getMatchingElements();
            this._recipeSourceItem = ingredients.isEmpty() ? ItemStack.f_41583_ : (ItemStack)ingredients.get(0);
            this._recipeProductItem = ((ItemStackRecipeResult)currentRecipe.getResult()).getResult();
        } else {
            this._recipeSourceItem = this._recipeProductItem = ItemStack.f_41583_;
        }
        this.callOnLogicalServer(() -> ((ReprocessorCollectorEntity)this).notifyTileEntityUpdate());
    }

    public boolean isRecipeRunning() {
        return this.isReprocessorActive();
    }

    public ItemStack getRecipeSourceItem() {
        return this._recipeSourceItem;
    }

    public ItemStack getRecipeProductItem() {
        return this._recipeProductItem;
    }

    public double getProgress() {
        return (double)this._tersTicker.getTicks() / 40.0;
    }

    public void onClientTick() {
        this.callOnLogicalClient(() -> ((Ticker)this._tersTicker).tick());
    }

    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            this._recipeSourceItem = ReprocessorCollectorEntity.syncItem(data, "source");
            this._recipeProductItem = ReprocessorCollectorEntity.syncItem(data, "product");
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            ReprocessorCollectorEntity.syncItem(data, "source", this._recipeSourceItem);
            ReprocessorCollectorEntity.syncItem(data, "product", this._recipeProductItem);
        }
        return data;
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (PartPosition.BottomFace == position) {
            return true;
        }
        validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.reprocessor.invalid_collector_position", new Object[0]);
        return false;
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    @Override
    public void onPostMachineAssembled(MultiblockReprocessor controller) {
        super.onPostMachineAssembled(controller);
        this._renderBoundingBox = (AABB)this.evalOnController(c -> (AABB)c.mapBoundingBoxCoordinates(AABB::new, CodeHelper.EMPTY_AABB), CodeHelper.EMPTY_AABB);
    }

    public AABB getRenderBoundingBox() {
        return this._renderBoundingBox;
    }

    public void m_142339_(Level world) {
        super.m_142339_(world);
        this._tersTicker = (Ticker)this.callOnLogicalClient(() -> new Ticker(40), () -> null);
    }

    private static void syncItem(CompoundTag data, String name, ItemStack stack) {
        if (!stack.m_41619_()) {
            data.m_128359_(name, ItemHelper.getItemId((ItemStack)stack).toString());
        }
    }

    @Nullable
    private static ItemStack syncItem(CompoundTag data, String name) {
        Item item;
        if (data.m_128441_(name) && null != (item = ItemHelper.getItemFrom((String)data.m_128461_(name)))) {
            return ItemHelper.stackFrom((ItemLike)item);
        }
        return ItemStack.f_41583_;
    }
}

