/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine;

import it.zerono.mods.extremereactors.api.coolant.Vapor;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbineData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.zerocore.lib.energy.EnergyBuffer;
import net.minecraft.util.profiling.ProfilerFiller;

public class TurbineLogic {
    private final ITurbineReader _turbine;
    private final TurbineData _data;
    private final EnergyBuffer _energyBuffer;

    TurbineLogic(ITurbineReader turbine, TurbineData data, EnergyBuffer energyBuffer) {
        this._turbine = turbine;
        this._data = data;
        this._energyBuffer = energyBuffer;
    }

    public void update() {
        ProfilerFiller profiler = this._turbine.getWorld().m_46473_();
        IFluidContainer fc = this._turbine.getFluidContainer();
        VentSetting ventSetting = this._data.getVentSetting();
        this.resetStats();
        int vaporAmount = 0;
        if (this._turbine.isMachineActive()) {
            vaporAmount = Math.min(this._data.getMaxIntakeRate(), this._turbine.getVaporAmount());
            if (ventSetting.isDoNotVent()) {
                int availableSpace = this._turbine.getCapacity() - this._turbine.getCoolantAmount();
                vaporAmount = Math.min(vaporAmount, availableSpace);
            }
        }
        if (vaporAmount > 0 || this._data.getRotorEnergy() > 0.0f) {
            float inductionTorque;
            float energyToGenerate;
            float rotorSpeed = this._turbine.getRotorSpeed();
            float aerodynamicDragTorque = rotorSpeed * this._data.getBladeDrag();
            float liftTorque = 0.0f;
            profiler.m_6180_("Energy");
            if (vaporAmount > 0) {
                float fluidEnergyDensity = fc.mapVapor(Vapor::getFluidEnergyDensity, Float.valueOf(0.0f)).floatValue();
                int steamToProcess = this._data.getBladeSurfaceArea() * this._data.getInputFluidPerBlade();
                steamToProcess = Math.min(steamToProcess, vaporAmount);
                liftTorque = (float)steamToProcess * fluidEnergyDensity;
                if (steamToProcess < vaporAmount) {
                    steamToProcess = vaporAmount - steamToProcess;
                    int neededBlades = vaporAmount / this._data.getInputFluidPerBlade();
                    int missingBlades = neededBlades - this._data.getBladeSurfaceArea();
                    float bladeEfficiency = 1.0f - (float)missingBlades / (float)neededBlades;
                    this._data.setRotorEfficiencyLastTick((liftTorque += (float)steamToProcess * fluidEnergyDensity * bladeEfficiency) / ((float)vaporAmount * fluidEnergyDensity));
                }
            }
            if ((energyToGenerate = (float)Math.pow(inductionTorque = this._data.isInductorEngaged() ? rotorSpeed * this._data.getInductorDragCoefficient() * (float)this._data.getCoilSize() : 0.0f, this._data.getInductionEnergyExponentBonus()) * this._data.getInductionEfficiency()) > 0.0f) {
                float efficiency = (float)(0.25 * Math.cos((double)rotorSpeed / 142.94246573833559)) + 0.75f;
                if (rotorSpeed < 500.0f) {
                    efficiency = Math.min(0.5f, efficiency);
                }
                this.generateEnergy(energyToGenerate * efficiency);
            }
            this._data.changeRotorEnergy(liftTorque + -1.0f * inductionTorque + -1.0f * aerodynamicDragTorque + -1.0f * this._data.getFrictionalDrag());
            profiler.m_6182_("Condensate");
            if (vaporAmount > 0) {
                fc.onCondensation(vaporAmount, ventSetting.isVentAll(), this._turbine.getVariant());
                this._data.setFluidConsumedLastTick(vaporAmount);
            }
            profiler.m_7238_();
        }
    }

    private void generateEnergy(double rawEnergy) {
        rawEnergy = rawEnergy * (Double)Config.COMMON.general.powerProductionMultiplier.get() * (Double)Config.COMMON.turbine.turbinePowerProductionMultiplier.get();
        this._energyBuffer.modifyEnergyStored(rawEnergy);
        this._data.changeEnergyGeneratedLastTick(rawEnergy);
    }

    private void resetStats() {
        this._data.setEnergyGeneratedLastTick(0.0);
        this._data.setFluidConsumedLastTick(0);
        this._data.setRotorEfficiencyLastTick(1.0f);
    }
}

