/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.AbstractMultiblockEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType2;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockVariantProvider;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelData;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelDataCache;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class AbstractTurbineEntity
extends AbstractMultiblockEntity<MultiblockTurbine>
implements IMultiblockPartTypeProvider<MultiblockTurbine, TurbinePartType>,
IMultiblockVariantProvider<IMultiblockTurbineVariant> {
    private static CuboidPartVariantsModelDataCache[] s_modelDataCaches;

    public AbstractTurbineEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    protected boolean isTurbineActive() {
        return this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).map(MultiblockTurbine::isMachineActive).orElse(false);
    }

    protected void setTurbineActive(boolean active) {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(c -> c.setMachineActive(active));
    }

    public Component getPartDisplayName() {
        return new TranslatableComponent("gui.bigreactors.multiblock_variant_part_format.title", new Object[]{new TranslatableComponent(this.getMultiblockVariant().map(IMultiblockVariant::getTranslationKey).orElse("unknown")), new TranslatableComponent(this.getPartType().map(IMultiblockPartType2::getTranslationKey).orElse("unknown"))});
    }

    @Override
    protected IModelData getUpdatedModelData() {
        return (IModelData)CodeHelper.optionalMap((Optional)this.getMultiblockVariant(), (Optional)this.getPartType(), this::getUpdatedModelData).orElse(EmptyModelData.INSTANCE);
    }

    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        BlockPos coordinates = this.getWorldPosition();
        if (position.isFrame()) {
            validatorCallback.setLastError(coordinates, "multiblock.validation.reactor.invalid_frame_block", new Object[0]);
            return false;
        }
        if (PartPosition.Interior == position) {
            validatorCallback.setLastError(coordinates, "multiblock.validation.reactor.invalid_part_for_interior", new Object[0]);
            return false;
        }
        return true;
    }

    public MultiblockTurbine createController() {
        Level myWorld = this.m_58904_();
        if (null == myWorld) {
            throw new RuntimeException("Trying to create a Controller from a Part without a Level");
        }
        return new MultiblockTurbine(this.m_58904_(), this.getMultiblockVariant().orElse(TurbineVariant.Basic));
    }

    public Class<MultiblockTurbine> getControllerType() {
        return MultiblockTurbine.class;
    }

    public void onMachineActivated() {
    }

    public void onMachineDeactivated() {
    }

    protected IModelData getUpdatedModelData(IMultiblockTurbineVariant variant, TurbinePartType partType) {
        return AbstractTurbineEntity.getVariantModelDataCache(variant).computeIfAbsent(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings(), () -> new CuboidPartVariantsModelData(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings()));
    }

    private static CuboidPartVariantsModelDataCache getVariantModelDataCache(IMultiblockTurbineVariant variant) {
        if (null == s_modelDataCaches) {
            s_modelDataCaches = new CuboidPartVariantsModelDataCache[ReactorVariant.values().length];
        }
        if (null == s_modelDataCaches[variant.getId()]) {
            AbstractTurbineEntity.s_modelDataCaches[variant.getId()] = new CuboidPartVariantsModelDataCache();
        }
        return s_modelDataCaches[variant.getId()];
    }
}

