/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.RotorDescriptor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.client.render.rotor.ShaftSection;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullConsumer;

public class TurbineRotorBearingEntity
extends AbstractTurbineEntity {
    private float _rotorAngle = 0.0f;
    private AABB _renderBoundingBox = INFINITE_EXTENT_AABB;
    private RotorDescriptor _rotorDescriptor = null;

    public TurbineRotorBearingEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)Content.TileEntityTypes.TURBINE_ROTORBEARING.get(), position, blockState);
    }

    public Direction getRotorDirection() {
        PartPosition partPosition = this.getPartPosition();
        if (partPosition.isFace()) {
            return partPosition.getDirection().map(Direction::m_122424_).orElse(Direction.UP);
        }
        return this.getOutwardFacingFromWorldPosition(Direction.DOWN).m_122424_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getRotorAngle() {
        return this._rotorAngle;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setRotorAngle(float angle) {
        this._rotorAngle = angle;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public RotorDescriptor getRotorDescriptor() {
        if (null == this._rotorDescriptor) {
            this._rotorDescriptor = this.buildRotorDescriptor();
        }
        return this._rotorDescriptor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isTurbineInteriorInvisible() {
        return (Boolean)this.evalOnController(AbstractMultiblockController::isInteriorInvisible, false);
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        if (position.isFace()) {
            return true;
        }
        validatorCallback.setLastError(this.getWorldPosition(), "multiblock.validation.turbine.invalid_bearing_position", new Object[0]);
        return false;
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    @Override
    public void onPostMachineAssembled(MultiblockTurbine controller) {
        super.onPostMachineAssembled(controller);
        this.resetRotorDescriptor();
    }

    @Override
    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.resetRotorDescriptor();
    }

    public AABB getRenderBoundingBox() {
        return this._renderBoundingBox;
    }

    private void resetRotorDescriptor() {
        this._rotorDescriptor = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private RotorDescriptor buildRotorDescriptor() {
        return (RotorDescriptor)this.evalOnController(turbine -> (RotorDescriptor)turbine.mapBoundingBoxCoordinates((min, max) -> this.buildRotorDescriptor((MultiblockTurbine)turbine, (BlockPos)min, (BlockPos)max), null), null);
    }

    @OnlyIn(value=Dist.CLIENT)
    private RotorDescriptor buildRotorDescriptor(MultiblockTurbine turbine, BlockPos turbineMin, BlockPos turbineMax) {
        this._renderBoundingBox = new AABB(turbineMin, turbineMax);
        Direction rotorDirection = this.getRotorDirection();
        int rotorLength = switch (rotorDirection.m_122434_()) {
            case Direction.Axis.X -> Math.abs(turbineMax.m_123341_() - turbineMin.m_123341_()) - 1;
            default -> Math.abs(turbineMax.m_123342_() - turbineMin.m_123342_()) - 1;
            case Direction.Axis.Z -> Math.abs(turbineMax.m_123343_() - turbineMin.m_123343_()) - 1;
        };
        List bladesDirections = CodeHelper.perpendicularDirections((Direction)rotorDirection);
        Level world = this.getPartWorldOrFail();
        RotorDescriptor.Builder rotorBuilder = RotorDescriptor.builder(TurbineVariant.from(turbine.getVariant()), rotorDirection, rotorLength);
        BlockPos shaftPosition = this.getWorldPosition().m_142300_(rotorDirection);
        int checkedSections = 0;
        do {
            RotorShaftState shaftState = WorldHelper.getTile((Level)world, (BlockPos)shaftPosition).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> TurbineRotorComponentEntity.computeShaftState((TurbineRotorComponentEntity)((Object)te))).orElse(RotorShaftState.HIDDEN);
            BlockPos bladesPosition = shaftPosition;
            rotorBuilder.section(shaftState, (NonNullConsumer<ShaftSection.Builder>)((NonNullConsumer)sectionBuilder -> this.buildShaftSection(world, bladesPosition, bladesDirections, (ShaftSection.Builder)sectionBuilder)));
            shaftPosition = shaftPosition.m_142300_(rotorDirection);
        } while (++checkedSections < rotorLength);
        return rotorBuilder.build();
    }

    private void buildShaftSection(Level world, BlockPos shaftPosition, List<Direction> bladesDirections, ShaftSection.Builder sectionBuilder) {
        for (Direction direction : bladesDirections) {
            BlockPos bladePosition = shaftPosition.m_142300_(direction);
            RotorBladeState state = WorldHelper.getTile((Level)world, (BlockPos)bladePosition).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> (TurbineRotorComponentEntity)((Object)te)).filter(TurbineRotorComponentEntity::isBlade).map(TurbineRotorComponentEntity::computeBladeState).orElse(RotorBladeState.HIDDEN);
            if (RotorBladeState.HIDDEN == state) continue;
            short bladeLength = 1;
            while (WorldHelper.getTile((Level)world, (BlockPos)(bladePosition = bladePosition.m_142300_(direction))).filter(te -> te instanceof TurbineRotorComponentEntity).map(te -> (TurbineRotorComponentEntity)((Object)te)).map(TurbineRotorComponentEntity::isBlade).orElse(false).booleanValue()) {
                bladeLength = (short)(bladeLength + 1);
            }
            sectionBuilder.addBlade(state, bladeLength, direction);
        }
    }
}

