/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.sensor;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.ISensorType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorBehavior;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.sensor.SensorTypeData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineReader;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import java.util.List;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.fml.LogicalSide;

public enum TurbineSensorType implements ISensorType<ITurbineReader>,
IDebuggable
{
    Disabled(SensorBehavior.Disabled),
    inputActive(SensorBehavior.SetFromSignal, SensorBehavior.ToggleOnPulse),
    inputEngageCoils(SensorBehavior.SetFromSignal, SensorBehavior.ToggleOnPulse),
    inputFlowRegulator(SensorBehavior.SetFromSignal, SensorBehavior.SetFromSignalLevel, SensorBehavior.SetOnPulse, SensorBehavior.InsertOnPulse, SensorBehavior.RetractOnPulse),
    outputRotorSpeed((NonNullFunction<ITurbineReader, Integer>)((NonNullFunction)r -> (int)r.getRotorSpeed()), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputEnergyAmount((NonNullFunction<ITurbineReader, Integer>)((NonNullFunction)r -> (int)(r.getEnergyStoredPercentage() * 100.0)), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputCoolantAmount((NonNullFunction<ITurbineReader, Integer>)((NonNullFunction)ITurbineReader::getCoolantAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween),
    outputVaporAmount((NonNullFunction<ITurbineReader, Integer>)((NonNullFunction)ITurbineReader::getVaporAmount), SensorBehavior.ActiveWhileAbove, SensorBehavior.ActiveWhileBelow, SensorBehavior.ActiveWhileBetween);

    private final SensorTypeData<ITurbineReader> _data;
    private final String _translationBaseName;

    private TurbineSensorType(SensorBehavior ... behaviors) {
        this(SensorTypeData.input(behaviors));
    }

    private TurbineSensorType(NonNullFunction<ITurbineReader, Integer> outputSupplier, SensorBehavior ... behaviors) {
        this(SensorTypeData.output(outputSupplier, behaviors));
    }

    @Override
    public boolean isDisabled() {
        return Disabled == this;
    }

    @Override
    public boolean isInput() {
        return this._data.isInput();
    }

    @Override
    public boolean isOutput() {
        return this._data.isOutput();
    }

    @Override
    public List<SensorBehavior> getBehaviors() {
        return this._data.getBehaviors();
    }

    public Integer apply(ITurbineReader reader) {
        return this._data.apply(reader);
    }

    @Override
    public String getTranslationBaseName() {
        return this._translationBaseName;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Turbine Sensor Type: %1$s", new Object[]{this});
    }

    private TurbineSensorType(SensorTypeData<ITurbineReader> _data) {
        this._data = _data;
        this._translationBaseName = "gui.bigreactors.turbine.redstoneport.sensortype." + CodeHelper.neutralLowercase((String)this.name()) + ".line";
    }
}

