/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.ISidedChemicalHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface IMekanismChemicalHandler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>>
extends ISidedChemicalHandler<CHEMICAL, STACK>,
IContentsListener {
    default public boolean canHandle() {
        return true;
    }

    public List<TANK> getChemicalTanks(@Nullable Direction var1);

    @Nullable
    default public TANK getChemicalTank(int tank, @Nullable Direction side) {
        List<TANK> tanks = this.getChemicalTanks(side);
        return (TANK)(tank >= 0 && tank < tanks.size() ? (IChemicalTank)tanks.get(tank) : null);
    }

    @Override
    default public int getTanks(@Nullable Direction side) {
        return this.getChemicalTanks(side).size();
    }

    @Override
    default public STACK getChemicalInTank(int tank, @Nullable Direction side) {
        TANK chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank == null ? this.getEmptyStack() : chemicalTank.getStack();
    }

    @Override
    default public void setChemicalInTank(int tank, STACK stack, @Nullable Direction side) {
        TANK chemicalTank = this.getChemicalTank(tank, side);
        if (chemicalTank != null) {
            chemicalTank.setStack(stack);
        }
    }

    @Override
    default public long getTankCapacity(int tank, @Nullable Direction side) {
        TANK chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank == null ? 0L : chemicalTank.getCapacity();
    }

    @Override
    default public boolean isValid(int tank, STACK stack, @Nullable Direction side) {
        TANK chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank != null && chemicalTank.isValid(stack);
    }

    @Override
    default public STACK insertChemical(int tank, STACK stack, @Nullable Direction side, Action action) {
        TANK chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank == null ? stack : chemicalTank.insert(stack, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }

    @Override
    default public STACK extractChemical(int tank, long amount, @Nullable Direction side, Action action) {
        TANK chemicalTank = this.getChemicalTank(tank, side);
        return chemicalTank == null ? this.getEmptyStack() : chemicalTank.extract(amount, action, side == null ? AutomationType.INTERNAL : AutomationType.EXTERNAL);
    }
}

