/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.merged;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.text.IHasTextComponent;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.registries.IForgeRegistryEntry;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BoxedChemical
implements IHasTextComponent {
    public static final BoxedChemical EMPTY = new BoxedChemical(ChemicalType.GAS, MekanismAPI.EMPTY_GAS);
    private final ChemicalType chemicalType;
    private final Chemical<?> chemical;

    public static BoxedChemical box(Chemical<?> chemical) {
        if (chemical.isEmptyType()) {
            return EMPTY;
        }
        return new BoxedChemical(ChemicalType.getTypeFor(chemical), chemical);
    }

    public static BoxedChemical read(FriendlyByteBuf buffer) {
        ChemicalType chemicalType = (ChemicalType)buffer.m_130066_(ChemicalType.class);
        return switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> new BoxedChemical(chemicalType, (Gas)buffer.readRegistryId());
            case ChemicalType.INFUSION -> new BoxedChemical(chemicalType, (InfuseType)buffer.readRegistryId());
            case ChemicalType.PIGMENT -> new BoxedChemical(chemicalType, (Pigment)buffer.readRegistryId());
            case ChemicalType.SLURRY -> new BoxedChemical(chemicalType, (Slurry)buffer.readRegistryId());
        };
    }

    public static BoxedChemical read(@Nullable CompoundTag nbt) {
        ChemicalType chemicalType = ChemicalType.fromNBT(nbt);
        Chemical chemical = null;
        if (chemicalType == ChemicalType.GAS) {
            chemical = Gas.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.INFUSION) {
            chemical = InfuseType.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.PIGMENT) {
            chemical = Pigment.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.SLURRY) {
            chemical = Slurry.readFromNBT(nbt);
        }
        return chemicalType == null || chemical == null ? EMPTY : new BoxedChemical(chemicalType, chemical);
    }

    protected BoxedChemical(ChemicalType chemicalType, Chemical<?> chemical) {
        this.chemicalType = chemicalType;
        this.chemical = chemical;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.chemical.isEmptyType();
    }

    public ChemicalType getChemicalType() {
        return this.chemicalType;
    }

    public CompoundTag write(CompoundTag nbt) {
        this.chemicalType.write(nbt);
        this.chemical.write(nbt);
        return nbt;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.chemicalType);
        switch (this.chemicalType) {
            case GAS: {
                buffer.writeRegistryId((IForgeRegistryEntry)((Gas)this.chemical));
                break;
            }
            case INFUSION: {
                buffer.writeRegistryId((IForgeRegistryEntry)((InfuseType)this.chemical));
                break;
            }
            case PIGMENT: {
                buffer.writeRegistryId((IForgeRegistryEntry)((Pigment)this.chemical));
                break;
            }
            case SLURRY: {
                buffer.writeRegistryId((IForgeRegistryEntry)((Slurry)this.chemical));
            }
        }
    }

    public Chemical<?> getChemical() {
        return this.chemical;
    }

    @Override
    public Component getTextComponent() {
        return this.chemical.getTextComponent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxedChemical other = (BoxedChemical)o;
        return this.chemicalType == other.chemicalType && this.chemical == other.chemical;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chemicalType, this.chemical});
    }
}

