/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.providers.IItemProvider;
import mekanism.client.gui.machine.GuiAdvancedElectricMachine;
import mekanism.client.gui.machine.GuiElectricMachine;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.FluidRegistryObject;
import mekanism.common.registration.impl.ParticleTypeRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.tile.prefab.TileEntityElectricMachine;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;

public class ClientRegistrationUtil {
    private static final BlockColor COLORED_BLOCK_COLOR = (state, world, pos, tintIndex) -> {
        Block block = state.m_60734_();
        if (block instanceof IColoredBlock) {
            IColoredBlock coloredBlock = (IColoredBlock)block;
            return MekanismRenderer.getColorARGB(coloredBlock.getColor(), 1.0f);
        }
        return -1;
    };
    private static final ItemColor COLORED_BLOCK_ITEM_COLOR = (stack, tintIndex) -> {
        BlockItem blockItem;
        Block block;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).m_40614_()) instanceof IColoredBlock) {
            IColoredBlock coloredBlock = (IColoredBlock)block;
            return MekanismRenderer.getColorARGB(coloredBlock.getColor(), 1.0f);
        }
        return -1;
    };

    private ClientRegistrationUtil() {
    }

    @SafeVarargs
    public static <T extends BlockEntity> void bindTileEntityRenderer(EntityRenderersEvent.RegisterRenderers event, final BlockEntityRendererProvider<T> rendererProvider, TileEntityTypeRegistryObject<? extends T> ... tileEntityTypeROs) {
        if (tileEntityTypeROs.length == 0) {
            throw new IllegalArgumentException("No renderers provided.");
        }
        if (tileEntityTypeROs.length == 1) {
            event.registerBlockEntityRenderer((BlockEntityType)tileEntityTypeROs[0].get(), rendererProvider);
        } else {
            BlockEntityRendererProvider provider = new BlockEntityRendererProvider<T>(){
                @Nullable
                private WeakReference<BlockEntityRendererProvider.Context> cachedContext;
                @Nullable
                private WeakReference<BlockEntityRenderer<T>> cachedRenderer;

                @Nonnull
                public BlockEntityRenderer<T> m_173570_(@Nonnull BlockEntityRendererProvider.Context context) {
                    BlockEntityRenderer renderer;
                    BlockEntityRenderer blockEntityRenderer = renderer = this.cachedRenderer == null ? null : (BlockEntityRenderer)this.cachedRenderer.get();
                    if (this.cachedContext == null || this.cachedContext.get() != context || renderer == null) {
                        renderer = rendererProvider.m_173570_(context);
                        this.cachedContext = new WeakReference<BlockEntityRendererProvider.Context>(context);
                        this.cachedRenderer = new WeakReference<BlockEntityRenderer>(renderer);
                    }
                    return renderer;
                }
            };
            for (TileEntityTypeRegistryObject<T> tileEntityTypeRegistryObject : tileEntityTypeROs) {
                event.registerBlockEntityRenderer((BlockEntityType)tileEntityTypeRegistryObject.get(), provider);
            }
        }
    }

    public static void registerClientReloadListeners(RegisterClientReloadListenersEvent event, PreparableReloadListener ... listeners) {
        for (PreparableReloadListener listener : listeners) {
            event.registerReloadListener(listener);
        }
    }

    public static <T extends ParticleOptions> void registerParticleFactory(ParticleTypeRegistryObject<T, ?> particleTypeRO, ParticleEngine.SpriteParticleRegistration<T> factory) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)particleTypeRO.get(), factory);
    }

    public static <C extends AbstractContainerMenu, U extends Screen> void registerScreen(ContainerTypeRegistryObject<C> type, MenuScreens.ScreenConstructor<C, U> factory) {
        MenuScreens.m_96206_((MenuType)((MenuType)type.get()), factory);
    }

    public static <TILE extends TileEntityElectricMachine, C extends MekanismTileContainer<TILE>> void registerElectricScreen(ContainerTypeRegistryObject<C> type) {
        ClientRegistrationUtil.registerScreen(type, new MenuScreens.ScreenConstructor<C, GuiElectricMachine<TILE, C>>(){

            @Nonnull
            public GuiElectricMachine<TILE, C> create(@Nonnull C container, @Nonnull Inventory inv, @Nonnull Component title) {
                return new GuiElectricMachine(container, inv, title);
            }
        });
    }

    public static <TILE extends TileEntityAdvancedElectricMachine, C extends MekanismTileContainer<TILE>> void registerAdvancedElectricScreen(ContainerTypeRegistryObject<C> type) {
        ClientRegistrationUtil.registerScreen(type, new MenuScreens.ScreenConstructor<C, GuiAdvancedElectricMachine<TILE, C>>(){

            @Nonnull
            public GuiAdvancedElectricMachine<TILE, C> create(@Nonnull C container, @Nonnull Inventory inv, @Nonnull Component title) {
                return new GuiAdvancedElectricMachine(container, inv, title);
            }
        });
    }

    public static synchronized void registerKeyBindings(KeyMapping ... keys) {
        for (KeyMapping key : keys) {
            ClientRegistry.registerKeyBinding((KeyMapping)key);
        }
    }

    public static void setPropertyOverride(IItemProvider itemProvider, ResourceLocation override, ItemPropertyFunction propertyGetter) {
        ItemProperties.register((Item)itemProvider.m_5456_(), (ResourceLocation)override, (ItemPropertyFunction)propertyGetter);
    }

    public static void registerItemColorHandler(ItemColors colors, ItemColor itemColor, IItemProvider ... items) {
        for (IItemProvider itemProvider : items) {
            colors.m_92689_(itemColor, new ItemLike[]{itemProvider.m_5456_()});
        }
    }

    public static void registerBlockColorHandler(BlockColors blockColors, BlockColor blockColor, IBlockProvider ... blocks) {
        for (IBlockProvider blockProvider : blocks) {
            blockColors.m_92589_(blockColor, new Block[]{blockProvider.getBlock()});
        }
    }

    public static void registerBlockColorHandler(BlockColors blockColors, ItemColors itemColors, BlockColor blockColor, ItemColor itemColor, IBlockProvider ... blocks) {
        for (IBlockProvider blockProvider : blocks) {
            blockColors.m_92589_(blockColor, new Block[]{blockProvider.getBlock()});
            itemColors.m_92689_(itemColor, new ItemLike[]{blockProvider.m_5456_()});
        }
    }

    public static void registerIColoredBlockHandler(BlockColors blockColors, ItemColors itemColors, IBlockProvider ... blocks) {
        ClientRegistrationUtil.registerBlockColorHandler(blockColors, itemColors, COLORED_BLOCK_COLOR, COLORED_BLOCK_ITEM_COLOR, blocks);
    }

    public static void setRenderLayer(RenderType type, Collection<? extends IBlockProvider> blockProviders) {
        for (IBlockProvider iBlockProvider : blockProviders) {
            ItemBlockRenderTypes.setRenderLayer((Block)iBlockProvider.getBlock(), (RenderType)type);
        }
    }

    public static void setRenderLayer(RenderType type, IBlockProvider ... blockProviders) {
        for (IBlockProvider blockProvider : blockProviders) {
            ItemBlockRenderTypes.setRenderLayer((Block)blockProvider.getBlock(), (RenderType)type);
        }
    }

    public static synchronized void setRenderLayer(Predicate<RenderType> predicate, IBlockProvider ... blockProviders) {
        for (IBlockProvider blockProvider : blockProviders) {
            ItemBlockRenderTypes.setRenderLayer((Block)blockProvider.getBlock(), predicate);
        }
    }

    public static void setRenderLayer(RenderType type, FluidRegistryObject<?, ?, ?, ?> ... fluidROs) {
        for (FluidRegistryObject<?, ?, ?, ?> fluidRO : fluidROs) {
            ItemBlockRenderTypes.setRenderLayer(fluidRO.getStillFluid(), (RenderType)type);
            ItemBlockRenderTypes.setRenderLayer(fluidRO.getFlowingFluid(), (RenderType)type);
        }
    }

    public static synchronized void setRenderLayer(Predicate<RenderType> predicate, FluidRegistryObject<?, ?, ?, ?> ... fluidROs) {
        for (FluidRegistryObject<?, ?, ?, ?> fluidRO : fluidROs) {
            ItemBlockRenderTypes.setRenderLayer(fluidRO.getStillFluid(), predicate);
            ItemBlockRenderTypes.setRenderLayer(fluidRO.getFlowingFluid(), predicate);
        }
    }
}

