/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.lib.ColorAtlas;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;

public abstract class GuiSideHolder
extends GuiTexturedElement {
    private static final ResourceLocation HOLDER_LEFT = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "holder_left.png");
    private static final ResourceLocation HOLDER_RIGHT = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "holder_right.png");
    private static final int TEXTURE_WIDTH = 26;
    private static final int TEXTURE_HEIGHT = 9;
    protected final boolean left;
    private final boolean slotHolder;

    public static GuiSideHolder armorHolder(IGuiWrapper gui) {
        return GuiSideHolder.create(gui, -26, 62, 98, true, true, SpecialColors.TAB_ARMOR_SLOTS);
    }

    public static GuiSideHolder create(IGuiWrapper gui, int x, int y, int height, boolean left, boolean slotHolder, final ColorAtlas.ColorRegistryObject tabColor) {
        return new GuiSideHolder(gui, x, y, height, left, slotHolder){

            @Override
            protected void colorTab() {
                MekanismRenderer.color(tabColor);
            }
        };
    }

    protected GuiSideHolder(IGuiWrapper gui, int x, int y, int height, boolean left, boolean slotHolder) {
        super(left ? HOLDER_LEFT : HOLDER_RIGHT, gui, x, y, 26, height);
        this.left = left;
        this.slotHolder = slotHolder;
        this.f_93623_ = false;
        if (!this.slotHolder) {
            this.setButtonBackground(GuiElement.ButtonBackground.DEFAULT);
        }
    }

    protected abstract void colorTab();

    @Override
    public void m_6303_(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.m_6303_(matrix, mouseX, mouseY, partialTicks);
        if (this.slotHolder) {
            this.draw(matrix, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        if (!this.slotHolder) {
            this.draw(matrix, mouseX, mouseY, partialTicks);
        }
    }

    private void draw(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        this.colorTab();
        GuiSideHolder.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)this.f_93618_, (int)4, (int)26, (int)9);
        int middleHeight = this.f_93619_ - 8;
        if (middleHeight > 0) {
            GuiSideHolder.m_93160_((PoseStack)matrix, (int)this.f_93620_, (int)(this.f_93621_ + 4), (int)this.f_93618_, (int)middleHeight, (float)0.0f, (float)4.0f, (int)this.f_93618_, (int)1, (int)26, (int)9);
        }
        GuiSideHolder.m_93133_((PoseStack)matrix, (int)this.f_93620_, (int)(this.f_93621_ + 4 + middleHeight), (float)0.0f, (float)5.0f, (int)this.f_93618_, (int)4, (int)26, (int)9);
        MekanismRenderer.resetColor();
    }
}

