/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.scroll.GuiScrollableElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;

public abstract class GuiScrollList
extends GuiScrollableElement {
    protected static final ResourceLocation SCROLL_LIST = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "scroll_list.png");
    protected static final int TEXTURE_WIDTH = 6;
    protected static final int TEXTURE_HEIGHT = 6;
    private final ResourceLocation background;
    private final int backgroundSideSize;
    protected final int elementHeight;

    protected GuiScrollList(IGuiWrapper gui, int x, int y, int width, int height, int elementHeight, ResourceLocation background, int backgroundSideSize) {
        super(SCROLL_LIST, gui, x, y, width, height, width - 6, 2, 4, 4, height - 4);
        this.elementHeight = elementHeight;
        this.background = background;
        this.backgroundSideSize = backgroundSideSize;
    }

    @Override
    protected int getFocusedElements() {
        return (this.f_93619_ - 2) / this.elementHeight;
    }

    public abstract boolean hasSelection();

    protected abstract void setSelected(int var1);

    public abstract void clearSelection();

    protected abstract void renderElements(PoseStack var1, int var2, int var3, float var4);

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(matrix, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(matrix, this.background, this.backgroundSideSize, this.backgroundSideSize);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
        GuiScrollList.m_93133_((PoseStack)matrix, (int)(this.barX - 1), (int)(this.barY - 1), (float)0.0f, (float)0.0f, (int)6, (int)1, (int)6, (int)6);
        GuiScrollList.m_93160_((PoseStack)matrix, (int)(this.barX - 1), (int)this.barY, (int)6, (int)this.maxBarHeight, (float)0.0f, (float)1.0f, (int)6, (int)1, (int)6, (int)6);
        GuiScrollList.m_93133_((PoseStack)matrix, (int)(this.barX - 1), (int)(this.f_93621_ + this.maxBarHeight + 2), (float)0.0f, (float)0.0f, (int)6, (int)1, (int)6, (int)6);
        GuiScrollList.m_93133_((PoseStack)matrix, (int)this.barX, (int)(this.barY + this.getScroll()), (float)0.0f, (float)2.0f, (int)this.barWidth, (int)this.barHeight, (int)6, (int)6);
        this.renderElements(matrix, mouseX, mouseY, partialTicks);
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        if (mouseX >= (double)(this.f_93620_ + 1) && mouseX < (double)(this.barX - 1) && mouseY >= (double)(this.f_93621_ + 1) && mouseY < (double)(this.f_93621_ + this.f_93619_ - 1)) {
            int index = this.getCurrentSelection();
            this.clearSelection();
            for (int i = 0; i < this.getFocusedElements(); ++i) {
                int shiftedY;
                if (index + i >= this.getMaxElements() || !(mouseY >= (double)(shiftedY = this.f_93621_ + 1 + this.elementHeight * i)) || !(mouseY <= (double)(shiftedY + this.elementHeight))) continue;
                this.setSelected(index + i);
                break;
            }
        }
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.m_5953_(mouseX, mouseY) && this.adjustScroll(delta) || super.m_6050_(mouseX, mouseY, delta);
    }
}

