/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.lib.security.ISecurityObject;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.network.to_server.PacketSecurityMode;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;

public class GuiSecurityTab
extends GuiInsetElement<ISecurityObject> {
    private static final ResourceLocation PUBLIC = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "public.png");
    private static final ResourceLocation PRIVATE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "private.png");
    private static final ResourceLocation PROTECTED = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "protected.png");
    @Nullable
    private final InteractionHand currentHand;

    private static ISecurityObject getItemSecurityObject(@Nonnull InteractionHand hand) {
        return SecurityUtils.wrapSecurityItem(() -> {
            ItemStack stack = GuiSecurityTab.minecraft.f_91074_.m_21120_(hand);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ISecurityItem)) {
                GuiSecurityTab.minecraft.f_91074_.m_6915_();
                return ItemStack.f_41583_;
            }
            return stack;
        });
    }

    public GuiSecurityTab(IGuiWrapper gui, ISecurityObject securityObject) {
        this(gui, securityObject, 34);
    }

    public GuiSecurityTab(IGuiWrapper gui, ISecurityObject securityObject, int y) {
        super(PUBLIC, gui, securityObject, gui.getWidth(), y, 26, 18, false);
        this.currentHand = null;
    }

    public GuiSecurityTab(IGuiWrapper gui, @Nonnull InteractionHand hand) {
        super(PUBLIC, gui, GuiSecurityTab.getItemSecurityObject(hand), gui.getWidth(), 34, 26, 18, false);
        this.currentHand = hand;
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(SpecialColors.TAB_SECURITY);
    }

    @Override
    protected ResourceLocation getOverlay() {
        SecurityData data;
        SecurityMode mode = this.getSecurity();
        UUID ownerUUID = ((ISecurityObject)this.dataSource).getOwnerUUID();
        SecurityData securityData = data = ownerUUID == null ? null : MekanismClient.clientSecurityMap.get(ownerUUID);
        if (data != null && data.override) {
            mode = data.mode;
        }
        if (mode == SecurityMode.PRIVATE) {
            return PRIVATE;
        }
        if (mode == SecurityMode.TRUSTED) {
            return PROTECTED;
        }
        return super.getOverlay();
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        MutableComponent securityComponent = MekanismLang.SECURITY.translateColored(EnumColor.GRAY, SecurityUtils.getSecurity((ISecurityObject)this.dataSource, Dist.CLIENT));
        Component ownerComponent = OwnerDisplay.of((Player)GuiSecurityTab.minecraft.f_91074_, ((ISecurityObject)this.dataSource).getOwnerUUID(), ((ISecurityObject)this.dataSource).getOwnerName()).getTextComponent();
        if (SecurityUtils.isOverridden((ISecurityObject)this.dataSource, Dist.CLIENT)) {
            this.displayTooltips(matrix, mouseX, mouseY, new Component[]{securityComponent, ownerComponent, MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0])});
        } else {
            this.displayTooltips(matrix, mouseX, mouseY, new Component[]{securityComponent, ownerComponent});
        }
    }

    private SecurityMode getSecurity() {
        return MekanismConfig.general.allowProtection.get() ? ((ISecurityObject)this.dataSource).getSecurityMode() : SecurityMode.PUBLIC;
    }

    public void m_5716_(double mouseX, double mouseY) {
        UUID owner;
        if (MekanismConfig.general.allowProtection.get() && (owner = ((ISecurityObject)this.dataSource).getOwnerUUID()) != null && GuiSecurityTab.minecraft.f_91074_.m_142081_().equals(owner)) {
            if (this.currentHand != null) {
                Mekanism.packetHandler().sendToServer(new PacketSecurityMode(this.currentHand, (SecurityMode)this.getSecurity().getNext()));
            } else {
                Object object = this.dataSource;
                if (object instanceof BlockEntity) {
                    BlockEntity tile = (BlockEntity)object;
                    Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.NEXT_SECURITY_MODE, tile));
                } else {
                    object = this.dataSource;
                    if (object instanceof Entity) {
                        Entity entity = (Entity)object;
                        Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionEntity.NEXT_SECURITY_MODE, entity));
                    }
                }
            }
        }
    }
}

