/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.functions.CharPredicate;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.window.filter.GuiTextFilter;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.text.InputValidator;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class GuiTagFilter<FILTER extends ITagFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiTextFilter<FILTER, TILE> {
    protected GuiTagFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, @Nullable FILTER origFilter) {
        super(gui, x, y, width, height, (Component)MekanismLang.TAG_FILTER.translate(new Object[0]), tile, origFilter);
    }

    @Override
    protected CharPredicate getInputValidator() {
        return InputValidator.RESOURCE_LOCATION.or(InputValidator.WILDCARD_CHARS);
    }

    @Override
    protected List<Component> getScreenText() {
        List<Component> list = super.getScreenText();
        list.add((Component)MekanismLang.TAG_FILTER_TAG.translate(((ITagFilter)this.filter).getTagName()));
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.TAG_FILTER_NO_TAG;
    }

    @Override
    protected boolean setText() {
        String name = this.text.getText();
        if (name.isEmpty()) {
            this.filterSaveFailed(this.getNoFilterSaveError(), new Object[0]);
        } else if (name.equals(((ITagFilter)this.filter).getTagName())) {
            this.filterSaveFailed(MekanismLang.TAG_FILTER_SAME_TAG, new Object[0]);
        } else if (!this.hasMatchingTargets(name)) {
            this.filterSaveFailed(MekanismLang.TEXT_FILTER_NO_MATCHES, new Object[0]);
        } else {
            ((ITagFilter)this.filter).setTagName(name);
            this.slotDisplay.updateStackList();
            this.text.setText("");
            this.filterSaveSuccess();
            return true;
        }
        return false;
    }

    protected boolean hasMatchingTargets(String name) {
        return !TagCache.getItemTagStacks(name).isEmpty();
    }

    @Override
    @Nonnull
    protected List<ItemStack> getRenderStacks() {
        if (((ITagFilter)this.filter).hasFilter()) {
            return TagCache.getItemTagStacks(((ITagFilter)this.filter).getTagName());
        }
        return Collections.emptyList();
    }
}

