/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.tile.machine.TileEntityPigmentMixer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@ParametersAreNonnullByDefault
public class RenderPigmentMixer
extends MekanismTileEntityRenderer<TileEntityPigmentMixer>
implements IWireFrameRenderer {
    private static final List<Vertex[]> vertices = new ArrayList<Vertex[]>();
    private static final float SHAFT_SPEED = 5.0f;

    public static void resetCached() {
        vertices.clear();
    }

    public RenderPigmentMixer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityPigmentMixer tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        if (tile.getActive()) {
            this.performTranslations(tile, partialTick, matrix);
            PoseStack.Pose entry = matrix.m_85850_();
            VertexConsumer buffer = renderer.m_6299_(Sheets.m_110789_());
            for (BakedQuad quad : MekanismModelCache.INSTANCE.PIGMENT_MIXER_SHAFT.getBakedModel().m_6840_(null, null, tile.m_58904_().f_46441_)) {
                buffer.putBulkData(entry, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlayLight);
            }
            matrix.m_85849_();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "pigmentMixer";
    }

    @Override
    public boolean hasSelectionBox(BlockState state) {
        return Attribute.isActive(state);
    }

    @Override
    public boolean isCombined() {
        return true;
    }

    @Override
    public void renderWireFrame(BlockEntity tile, float partialTick, PoseStack matrix, VertexConsumer buffer, float red, float green, float blue, float alpha) {
        if (tile instanceof TileEntityPigmentMixer) {
            TileEntityPigmentMixer mixer = (TileEntityPigmentMixer)tile;
            this.performTranslations(mixer, partialTick, matrix);
            if (vertices.isEmpty()) {
                for (Quad quad : QuadUtils.unpack(MekanismModelCache.INSTANCE.PIGMENT_MIXER_SHAFT.getBakedModel().m_6840_(null, null, tile.m_58904_().f_46441_))) {
                    vertices.add(quad.getVertices());
                }
            }
            RenderTickHandler.renderVertexWireFrame(vertices, buffer, matrix.m_85850_().m_85861_(), red, green, blue, alpha);
            matrix.m_85849_();
        }
    }

    private void performTranslations(TileEntityPigmentMixer tile, float partialTick, PoseStack matrix) {
        matrix.m_85836_();
        switch (tile.getDirection()) {
            case NORTH: {
                matrix.m_85837_(0.4375, 0.0, 0.375);
                break;
            }
            case SOUTH: {
                matrix.m_85837_(0.4375, 0.0, 0.5);
                break;
            }
            case WEST: {
                matrix.m_85837_(0.375, 0.0, 0.4375);
                break;
            }
            case EAST: {
                matrix.m_85837_(0.5, 0.0, 0.4375);
            }
        }
        float shift = 0.0625f;
        matrix.m_85837_((double)shift, 0.0, (double)shift);
        matrix.m_85845_(Vector3f.f_122224_.m_122240_(((float)tile.m_58904_().m_46467_() + partialTick) * 5.0f % 360.0f));
        matrix.m_85837_((double)(-shift), 0.0, (double)(-shift));
    }
}

