/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.model.ModelSeismicVibrator;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntitySeismicVibrator;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.entity.BlockEntity;

@ParametersAreNonnullByDefault
public class RenderSeismicVibrator
extends MekanismTileEntityRenderer<TileEntitySeismicVibrator>
implements IWireFrameRenderer {
    private final ModelSeismicVibrator model;

    public RenderSeismicVibrator(BlockEntityRendererProvider.Context context) {
        super(context);
        this.model = new ModelSeismicVibrator(context.m_173585_());
    }

    @Override
    protected void render(TileEntitySeismicVibrator tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        float actualRate = this.performTranslationsAndGetRate(tile, partialTick, matrix);
        this.model.render(matrix, renderer, light, overlayLight, actualRate, false);
        matrix.m_85849_();
    }

    @Override
    protected String getProfilerSection() {
        return "seismicVibrator";
    }

    public boolean shouldRenderOffScreen(TileEntitySeismicVibrator tile) {
        return true;
    }

    @Override
    public void renderWireFrame(BlockEntity tile, float partialTick, PoseStack matrix, VertexConsumer buffer, float red, float green, float blue, float alpha) {
        if (tile instanceof TileEntitySeismicVibrator) {
            TileEntitySeismicVibrator vibrator = (TileEntitySeismicVibrator)tile;
            float actualRate = this.performTranslationsAndGetRate(vibrator, partialTick, matrix);
            this.model.renderWireFrame(matrix, buffer, actualRate, red, green, blue, alpha);
            matrix.m_85849_();
        }
    }

    private float performTranslationsAndGetRate(TileEntitySeismicVibrator tile, float partialTick, PoseStack matrix) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 1.5, 0.5);
        MekanismRenderer.rotate(matrix, tile.getDirection(), 0.0f, 180.0f, 90.0f, 270.0f);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        return Math.max(0.0f, (float)Math.sin(((float)tile.clientPiston + (tile.getActive() ? partialTick : 0.0f)) / 5.0f));
    }
}

