/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.transmitter.BoxedPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderPressurizedTube
extends RenderTransmitterBase<TileEntityPressurizedTube> {
    public RenderPressurizedTube(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityPressurizedTube tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        BoxedPressurizedTube tube = tile.getTransmitter();
        if (tube.hasTransmitterNetwork()) {
            BoxedChemicalNetwork network = (BoxedChemicalNetwork)tube.getTransmitterNetwork();
            if (!network.lastChemical.isEmpty() && !network.isTankEmpty() && network.currentScale > 0.0f) {
                matrix.m_85836_();
                matrix.m_85837_(0.5, 0.5, 0.5);
                Chemical<?> chemical = network.lastChemical.getChemical();
                this.renderModel(tile, matrix, renderer.m_6299_(Sheets.m_110792_()), chemical.getTint(), Math.max(0.2f, network.currentScale), 0xF000F0, overlayLight, MekanismRenderer.getChemicalTexture(chemical));
                matrix.m_85849_();
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "pressurizedTube";
    }
}

