/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.gear.IModuleContainerItem;
import mekanism.common.content.gear.mekasuit.ModuleGravitationalModulatingUnit;
import mekanism.common.content.gear.mekasuit.ModuleHydraulicPropulsionUnit;
import mekanism.common.content.gear.mekasuit.ModuleJetpackUnit;
import mekanism.common.content.gear.mekasuit.ModuleLocomotiveBoostingUnit;
import mekanism.common.entity.EntityFlame;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemFreeRunners;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.item.gear.ItemScubaMask;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismModules;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonPlayerTickHandler {
    public static boolean isOnGroundOrSleeping(Player player) {
        return player.m_20096_() || player.m_5803_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isScubaMaskOn(Player player, ItemStack tank) {
        ItemStack mask = player.m_6844_(EquipmentSlot.HEAD);
        if (tank.m_41619_()) return false;
        if (mask.m_41619_()) return false;
        Item item = tank.m_41720_();
        if (!(item instanceof ItemScubaTank)) return false;
        ItemScubaTank scubaTank = (ItemScubaTank)item;
        if (!(mask.m_41720_() instanceof ItemScubaMask)) return false;
        if (!ChemicalUtil.hasGas(tank)) return false;
        if (!scubaTank.getFlowing(tank)) return false;
        return true;
    }

    private static boolean isFlamethrowerOn(Player player, ItemStack currentItem) {
        return Mekanism.playerState.isFlamethrowerOn(player) && !currentItem.m_41619_() && currentItem.m_41720_() instanceof ItemFlamethrower;
    }

    public static float getStepBoost(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.FEET);
        if (!stack.m_41619_() && !player.m_6144_()) {
            ItemFreeRunners freeRunners;
            Item item = stack.m_41720_();
            if (item instanceof ItemFreeRunners && (freeRunners = (ItemFreeRunners)item).getMode(stack) == ItemFreeRunners.FreeRunnerMode.NORMAL) {
                return 0.5f;
            }
            IModule<ModuleHydraulicPropulsionUnit> module = MekanismAPI.getModuleHelper().load(stack, MekanismModules.HYDRAULIC_PROPULSION_UNIT);
            if (module != null && module.isEnabled()) {
                return module.getCustomInstance().getStepHeight();
            }
        }
        return 0.0f;
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            this.tickEnd(event.player);
        }
    }

    private void tickEnd(Player player) {
        ItemStack chest;
        EntityFlame flame;
        ItemStack currentItem;
        Mekanism.playerState.updateStepAssist(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RadiationManager.INSTANCE.tickServer(serverPlayer);
        }
        if (CommonPlayerTickHandler.isFlamethrowerOn(player, currentItem = player.m_150109_().m_36056_()) && (flame = EntityFlame.create(player)) != null) {
            if (flame.m_6084_()) {
                player.f_19853_.m_7967_((Entity)flame);
            }
            if (MekanismUtils.isPlayingMode(player)) {
                ((ItemFlamethrower)currentItem.m_41720_()).useGas(currentItem, 1L);
            }
        }
        if (CommonPlayerTickHandler.isJetpackOn(player, chest = player.m_6844_(EquipmentSlot.CHEST))) {
            Item item;
            ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chest);
            if (CommonPlayerTickHandler.handleJetpackMotion(player, mode, () -> Mekanism.keyMap.has(player.m_142081_(), 0))) {
                player.f_19789_ = 0.0f;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.f_9737_ = 0;
                }
            }
            if ((item = chest.m_41720_()) instanceof ItemJetpack) {
                ItemJetpack jetpack = (ItemJetpack)item;
                jetpack.useGas(chest, 1L);
            } else {
                ((ItemMekaSuitArmor)chest.m_41720_()).useGas(chest, (Gas)MekanismGases.HYDROGEN.get(), 1L);
            }
        }
        if (CommonPlayerTickHandler.isScubaMaskOn(player, chest)) {
            ItemScubaTank tank = (ItemScubaTank)chest.m_41720_();
            int max = player.m_6062_();
            tank.useGas(chest, 1L);
            GasStack received = tank.useGas(chest, max - player.m_20146_());
            if (!received.isEmpty()) {
                player.m_20301_(player.m_20146_() + (int)received.getAmount());
            }
            if (player.m_20146_() == max) {
                for (MobEffectInstance effect : player.m_21220_()) {
                    for (int i = 0; i < 9; ++i) {
                        MekanismUtils.speedUpEffectSafely((LivingEntity)player, effect);
                    }
                }
            }
        }
        Mekanism.playerState.updateFlightInfo(player);
    }

    public static boolean handleJetpackMotion(Player player, ItemJetpack.JetpackMode mode, BooleanSupplier ascendingSupplier) {
        Vec3 motion = player.m_20184_();
        if (mode == ItemJetpack.JetpackMode.NORMAL) {
            if (player.m_21255_()) {
                Vec3 lookAngle = player.m_20154_();
                Vec3 normalizedLook = lookAngle.m_82541_();
                double d1x = normalizedLook.f_82479_ * 0.15;
                double d1y = normalizedLook.f_82480_ * 0.15;
                double d1z = normalizedLook.f_82481_ * 0.15;
                player.m_20256_(motion.m_82520_(lookAngle.f_82479_ * d1x + (lookAngle.f_82479_ * 1.5 - motion.f_82479_) * 0.5, lookAngle.f_82480_ * d1y + (lookAngle.f_82480_ * 1.5 - motion.f_82480_) * 0.5, lookAngle.f_82481_ * d1z + (lookAngle.f_82481_ * 1.5 - motion.f_82481_) * 0.5));
                return false;
            }
            player.m_20334_(motion.m_7096_(), Math.min(motion.m_7098_() + 0.15, 0.5), motion.m_7094_());
        } else if (mode == ItemJetpack.JetpackMode.HOVER) {
            boolean ascending = ascendingSupplier.getAsBoolean();
            boolean descending = player.m_20164_();
            if (!ascending && !descending || ascending && descending) {
                if (motion.m_7098_() > 0.0) {
                    player.m_20334_(motion.m_7096_(), Math.max(motion.m_7098_() - 0.15, 0.0), motion.m_7094_());
                } else if (motion.m_7098_() < 0.0 && !CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                    player.m_20334_(motion.m_7096_(), Math.min(motion.m_7098_() + 0.15, 0.0), motion.m_7094_());
                }
            } else if (ascending) {
                player.m_20334_(motion.m_7096_(), Math.min(motion.m_7098_() + 0.15, 0.2), motion.m_7094_());
            } else if (!CommonPlayerTickHandler.isOnGroundOrSleeping(player)) {
                player.m_20334_(motion.m_7096_(), Math.max(motion.m_7098_() - 0.15, -0.2), motion.m_7094_());
            }
        }
        return true;
    }

    private static boolean isJetpackOn(Player player, ItemStack chest) {
        if (!chest.m_41619_() && !player.m_5833_()) {
            ItemJetpack.JetpackMode mode = CommonPlayerTickHandler.getJetpackMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return Mekanism.keyMap.has(player.m_142081_(), 0);
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = Mekanism.keyMap.has(player.m_142081_(), 0);
                boolean descending = player.m_20164_();
                if (!ascending || descending) {
                    return !CommonPlayerTickHandler.isOnGroundOrSleeping(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isGravitationalModulationReady(Player player) {
        IModule<ModuleGravitationalModulatingUnit> module = MekanismAPI.getModuleHelper().load(player.m_6844_(EquipmentSlot.CHEST), MekanismModules.GRAVITATIONAL_MODULATING_UNIT);
        FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageGravitationalModulation.get();
        return MekanismUtils.isPlayingMode(player) && module != null && module.isEnabled() && module.getContainerEnergy().greaterOrEqual(usage);
    }

    public static boolean isGravitationalModulationOn(Player player) {
        return CommonPlayerTickHandler.isGravitationalModulationReady(player) && player.m_150110_().f_35935_;
    }

    public static ItemJetpack.JetpackMode getJetpackMode(ItemStack stack) {
        IModule<ModuleJetpackUnit> module;
        Item item = stack.m_41720_();
        if (item instanceof ItemJetpack) {
            ItemJetpack jetpack = (ItemJetpack)item;
            if (ChemicalUtil.hasGas(stack)) {
                return jetpack.getMode(stack);
            }
        }
        if (stack.m_41720_() instanceof IModuleContainerItem && ChemicalUtil.hasChemical(stack, (Gas)MekanismGases.HYDROGEN.get()) && (module = MekanismAPI.getModuleHelper().load(stack, MekanismModules.JETPACK_UNIT)) != null && module.isEnabled()) {
            return module.getCustomInstance().getMode();
        }
        return ItemJetpack.JetpackMode.DISABLED;
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        Player player;
        FallEnergyInfo info;
        ItemScubaTank tank;
        Item item;
        ItemStack chestStack;
        ItemStack headStack;
        LivingEntity entity = event.getEntityLiving();
        if (event.getAmount() <= 0.0f || !entity.m_6084_()) {
            return;
        }
        if (event.getSource().m_19387_() && !(headStack = entity.m_6844_(EquipmentSlot.HEAD)).m_41619_() && headStack.m_41720_() instanceof ItemScubaMask && !(chestStack = entity.m_6844_(EquipmentSlot.CHEST)).m_41619_() && (item = chestStack.m_41720_()) instanceof ItemScubaTank && (tank = (ItemScubaTank)item).getFlowing(chestStack) && ChemicalUtil.hasGas(chestStack)) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource().m_146707_() && (info = this.getFallAbsorptionEnergyInfo(entity)) != null && this.tryAbsorbAll(event, info.container, info.damageRatio, info.energyCost)) {
            return;
        }
        if (entity instanceof Player && ItemMekaSuitArmor.tryAbsorbAll(player = (Player)entity, event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Player player;
        float ratioAbsorbed;
        FallEnergyInfo info;
        LivingEntity entity = event.getEntityLiving();
        if (event.getAmount() <= 0.0f || !entity.m_6084_()) {
            return;
        }
        if (event.getSource().m_146707_() && (info = this.getFallAbsorptionEnergyInfo(entity)) != null && this.handleDamage(event, info.container, info.damageRatio, info.energyCost)) {
            return;
        }
        if (entity instanceof Player && (ratioAbsorbed = ItemMekaSuitArmor.getDamageAbsorbed(player = (Player)entity, event.getSource(), event.getAmount())) > 0.0f) {
            float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
            if (damageRemaining <= 0.0f) {
                event.setCanceled(true);
            } else {
                event.setAmount(damageRemaining);
            }
        }
    }

    private boolean tryAbsorbAll(LivingAttackEvent event, @Nullable IEnergyContainer energyContainer, FloatSupplier absorptionRatio, FloatingLongSupplier energyCost) {
        if (energyContainer != null && absorptionRatio.getAsFloat() == 1.0f) {
            FloatingLong energyRequirement = energyCost.get().multiply(event.getAmount());
            if (energyRequirement.isZero()) {
                event.setCanceled(true);
                return true;
            }
            FloatingLong simulatedExtract = energyContainer.extract(energyRequirement, Action.SIMULATE, AutomationType.MANUAL);
            if (simulatedExtract.equals(energyRequirement)) {
                energyContainer.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL);
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    private boolean handleDamage(LivingHurtEvent event, @Nullable IEnergyContainer energyContainer, FloatSupplier absorptionRatio, FloatingLongSupplier energyCost) {
        if (energyContainer != null) {
            float absorption = absorptionRatio.getAsFloat();
            float amount = event.getAmount() * absorption;
            FloatingLong energyRequirement = energyCost.get().multiply(amount);
            float ratioAbsorbed = energyRequirement.isZero() ? absorption : absorption * energyContainer.extract(energyRequirement, Action.EXECUTE, AutomationType.MANUAL).divide(amount).floatValue();
            if (ratioAbsorbed > 0.0f) {
                float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
                if (damageRemaining <= 0.0f) {
                    event.setCanceled(true);
                    return true;
                }
                event.setAmount(damageRemaining);
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            IModule<ModuleHydraulicPropulsionUnit> module = MekanismAPI.getModuleHelper().load(player.m_6844_(EquipmentSlot.FEET), MekanismModules.HYDRAULIC_PROPULSION_UNIT);
            if (module != null && module.isEnabled() && Mekanism.keyMap.has(player.m_142081_(), 1)) {
                float boost = module.getCustomInstance().getBoost();
                FloatingLong usage = ((FloatingLong)MekanismConfig.gear.mekaSuitBaseJumpEnergyUsage.get()).multiply(boost / 0.1f);
                IEnergyContainer energyContainer = module.getEnergyContainer();
                if (module.canUseEnergy((LivingEntity)player, energyContainer, usage, false)) {
                    IModule<ModuleLocomotiveBoostingUnit> boostModule = MekanismAPI.getModuleHelper().load(player.m_6844_(EquipmentSlot.LEGS), MekanismModules.LOCOMOTIVE_BOOSTING_UNIT);
                    if (boostModule != null && boostModule.isEnabled() && boostModule.getCustomInstance().canFunction(boostModule, player)) {
                        boost = (float)Math.sqrt(boost);
                    }
                    player.m_20256_(player.m_20184_().m_82520_(0.0, (double)boost, 0.0));
                    module.useEnergy((LivingEntity)player, energyContainer, usage, true);
                }
            }
        }
    }

    @Nullable
    private FallEnergyInfo getFallAbsorptionEnergyInfo(LivingEntity base) {
        ItemStack feetStack = base.m_6844_(EquipmentSlot.FEET);
        if (!feetStack.m_41619_()) {
            Item item = feetStack.m_41720_();
            if (item instanceof ItemFreeRunners) {
                ItemFreeRunners boots = (ItemFreeRunners)item;
                if (boots.getMode(feetStack) == ItemFreeRunners.FreeRunnerMode.NORMAL) {
                    return new FallEnergyInfo(StorageUtils.getEnergyContainer(feetStack, 0), MekanismConfig.gear.freeRunnerFallDamageRatio, MekanismConfig.gear.freeRunnerFallEnergyCost);
                }
            } else if (feetStack.m_41720_() instanceof ItemMekaSuitArmor) {
                return new FallEnergyInfo(StorageUtils.getEnergyContainer(feetStack, 0), MekanismConfig.gear.mekaSuitFallDamageRatio, MekanismConfig.gear.mekaSuitEnergyUsageFall);
            }
        }
        return null;
    }

    private record FallEnergyInfo(@Nullable IEnergyContainer container, FloatSupplier damageRatio, FloatingLongSupplier energyCost) {
    }
}

