/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.IAlloyInteraction;
import mekanism.api.IConfigCardAccess;
import mekanism.api.IConfigurable;
import mekanism.api.IEvaporationSolar;
import mekanism.api.MekanismAPI;
import mekanism.api.MekanismIMC;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.gear.ModuleData;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.lasers.ILaserDissipation;
import mekanism.api.lasers.ILaserReceptor;
import mekanism.api.providers.IItemProvider;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.api.radiation.capability.IRadiationShielding;
import mekanism.api.robit.RobitSkin;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.CommonPlayerTracker;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.CreativeTabMekanism;
import mekanism.common.MekanismLang;
import mekanism.common.ReloadListener;
import mekanism.common.base.IModModule;
import mekanism.common.base.KeySync;
import mekanism.common.base.MekFakePlayer;
import mekanism.common.base.PlayerState;
import mekanism.common.base.TagCache;
import mekanism.common.command.CommandMek;
import mekanism.common.command.builders.BuildCommand;
import mekanism.common.command.builders.Builders;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.content.boiler.BoilerMultiblockData;
import mekanism.common.content.boiler.BoilerValidator;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.content.evaporation.EvaporationValidator;
import mekanism.common.content.gear.MekaSuitDispenseBehavior;
import mekanism.common.content.gear.ModuleDispenseBehavior;
import mekanism.common.content.gear.ModuleHelper;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.content.matrix.MatrixValidator;
import mekanism.common.content.network.BoxedChemicalNetwork;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.FluidNetwork;
import mekanism.common.content.sps.SPSCache;
import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.content.sps.SPSValidator;
import mekanism.common.content.tank.TankCache;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.content.tank.TankValidator;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.integration.crafttweaker.content.CrTContentUtils;
import mekanism.common.item.block.machine.ItemBlockFluidTank;
import mekanism.common.lib.MekAnnotationScanner;
import mekanism.common.lib.Version;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.transmitter.TransmitterNetworkRegistry;
import mekanism.common.network.PacketHandler;
import mekanism.common.network.to_client.PacketTransmitterUpdate;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.bin.BinInsertRecipe;
import mekanism.common.recipe.condition.ModVersionLoadedCondition;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismDataSerializers;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.registries.MekanismFeatures;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismHeightProviderTypes;
import mekanism.common.registries.MekanismInfuseTypes;
import mekanism.common.registries.MekanismIntProviderTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismModules;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.registries.MekanismPigments;
import mekanism.common.registries.MekanismPlacementModifiers;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.registries.MekanismRobitSkins;
import mekanism.common.registries.MekanismSlurries;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tile.component.TileComponentChunkLoader;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.world.GenHandler;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mekanism")
public class Mekanism {
    public static final String MODID = "mekanism";
    public static final String MOD_NAME = "Mekanism";
    public static final String LOG_TAG = "[Mekanism]";
    public static final PlayerState playerState = new PlayerState();
    private final PacketHandler packetHandler;
    public static final Logger logger = LogManager.getLogger((String)"Mekanism");
    public static Mekanism instance;
    public static final MekanismHooks hooks;
    public final Version versionNumber;
    public static final MultiblockManager<TankMultiblockData> tankManager;
    public static final MultiblockManager<MatrixMultiblockData> matrixManager;
    public static final MultiblockManager<BoilerMultiblockData> boilerManager;
    public static final MultiblockManager<EvaporationMultiblockData> evaporationManager;
    public static final MultiblockManager<SPSMultiblockData> spsManager;
    public static final CreativeTabMekanism tabMekanism;
    public static final List<IModModule> modulesLoaded;
    public static final CommonWorldTickHandler worldTickHandler;
    public static final GameProfile gameProfile;
    public static final KeySync keyMap;
    public static final Set<Coord4D> activeVibrators;
    private ReloadListener recipeCacheManager;

    public Mekanism() {
        instance = this;
        MekanismConfig.registerConfigs(ModLoadingContext.get());
        MinecraftForge.EVENT_BUS.addListener(this::onEnergyTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::onChemicalTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::onLiquidTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldUnload);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::addReloadListenersLowest);
        MinecraftForge.EVENT_BUS.addListener(BinInsertRecipe::onCrafting);
        MinecraftForge.EVENT_BUS.addListener(this::onTagsReload);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, GenHandler::onBiomeLoad);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::imcQueue);
        modEventBus.addListener(this::imcHandle);
        MekanismItems.ITEMS.register(modEventBus);
        MekanismBlocks.BLOCKS.register(modEventBus);
        MekanismFluids.FLUIDS.register(modEventBus);
        MekanismContainerTypes.CONTAINER_TYPES.register(modEventBus);
        MekanismEntityTypes.ENTITY_TYPES.register(modEventBus);
        MekanismTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        MekanismSounds.SOUND_EVENTS.register(modEventBus);
        MekanismParticleTypes.PARTICLE_TYPES.register(modEventBus);
        MekanismHeightProviderTypes.HEIGHT_PROVIDER_TYPES.register(modEventBus);
        MekanismIntProviderTypes.INT_PROVIDER_TYPES.register(modEventBus);
        MekanismPlacementModifiers.PLACEMENT_MODIFIERS.register(modEventBus);
        MekanismFeatures.FEATURES.register(modEventBus);
        MekanismFeatures.SETUP_FEATURES.register(modEventBus);
        MekanismRecipeType.RECIPE_TYPES.register(modEventBus);
        MekanismRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        MekanismDataSerializers.DATA_SERIALIZERS.register(modEventBus);
        MekanismGases.GASES.createAndRegister(modEventBus, Gas.class, builder -> builder.hasTags().setDefaultKey(Mekanism.rl("empty")));
        MekanismInfuseTypes.INFUSE_TYPES.createAndRegister(modEventBus, InfuseType.class, builder -> builder.hasTags().setDefaultKey(Mekanism.rl("empty")));
        MekanismPigments.PIGMENTS.createAndRegister(modEventBus, Pigment.class, builder -> builder.hasTags().setDefaultKey(Mekanism.rl("empty")));
        MekanismSlurries.SLURRIES.createAndRegister(modEventBus, Slurry.class, builder -> builder.hasTags().setDefaultKey(Mekanism.rl("empty")));
        MekanismRobitSkins.ROBIT_SKINS.createAndRegister(modEventBus, RobitSkin.class, builder -> builder.setDefaultKey(Mekanism.rl("robit")));
        MekanismModules.MODULES.createAndRegister(modEventBus, ModuleData.class);
        modEventBus.addGenericListener(Gas.class, this::registerGases);
        modEventBus.addGenericListener(InfuseType.class, this::registerInfuseTypes);
        modEventBus.addGenericListener(Pigment.class, this::registerPigments);
        modEventBus.addGenericListener(Slurry.class, this::registerSlurries);
        modEventBus.addGenericListener(RecipeSerializer.class, this::registerRecipeSerializers);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
        this.packetHandler = new PacketHandler();
        hooks.hookConstructor();
        if (Mekanism.hooks.CraftTweakerLoaded && !DatagenModLoader.isRunningDataGen()) {
            ModContainer container;
            IEventBus crtModEventBus = modEventBus;
            Optional crtModContainer = ModList.get().getModContainerById("crafttweaker");
            if (crtModContainer.isPresent() && (container = (ModContainer)crtModContainer.get()) instanceof FMLModContainer) {
                FMLModContainer modContainer = (FMLModContainer)container;
                crtModEventBus = modContainer.getEventBus();
            }
            crtModEventBus.addGenericListener(Gas.class, EventPriority.LOWEST, CrTContentUtils::registerCrTGases);
            crtModEventBus.addGenericListener(InfuseType.class, EventPriority.LOWEST, CrTContentUtils::registerCrTInfuseTypes);
            crtModEventBus.addGenericListener(Pigment.class, EventPriority.LOWEST, CrTContentUtils::registerCrTPigments);
            crtModEventBus.addGenericListener(Slurry.class, EventPriority.LOWEST, CrTContentUtils::registerCrTSlurries);
            crtModEventBus.addGenericListener(RobitSkin.class, EventPriority.LOWEST, CrTContentUtils::registerCrTRobitSkins);
        }
    }

    public static PacketHandler packetHandler() {
        return Mekanism.instance.packetHandler;
    }

    private void registerGases(RegistryEvent.Register<Gas> event) {
        MekanismAPI.EMPTY_GAS.setRegistryName(Mekanism.rl("empty"));
        event.getRegistry().register((IForgeRegistryEntry)MekanismAPI.EMPTY_GAS);
    }

    private void registerInfuseTypes(RegistryEvent.Register<InfuseType> event) {
        MekanismAPI.EMPTY_INFUSE_TYPE.setRegistryName(Mekanism.rl("empty"));
        event.getRegistry().register((IForgeRegistryEntry)MekanismAPI.EMPTY_INFUSE_TYPE);
    }

    private void registerPigments(RegistryEvent.Register<Pigment> event) {
        MekanismAPI.EMPTY_PIGMENT.setRegistryName(Mekanism.rl("empty"));
        event.getRegistry().register((IForgeRegistryEntry)MekanismAPI.EMPTY_PIGMENT);
    }

    private void registerSlurries(RegistryEvent.Register<Slurry> event) {
        MekanismAPI.EMPTY_SLURRY.setRegistryName(Mekanism.rl("empty"));
        event.getRegistry().register((IForgeRegistryEntry)MekanismAPI.EMPTY_SLURRY);
    }

    private void registerRecipeSerializers(RegistryEvent.Register<RecipeSerializer<?>> event) {
        CraftingHelper.register((IConditionSerializer)ModVersionLoadedCondition.Serializer.INSTANCE);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void setRecipeCacheManager(ReloadListener manager) {
        if (this.recipeCacheManager == null) {
            this.recipeCacheManager = manager;
        } else {
            logger.warn("Recipe cache manager has already been set.");
        }
    }

    public ReloadListener getRecipeCacheManager() {
        return this.recipeCacheManager;
    }

    private void onTagsReload(TagsUpdatedEvent event) {
        TagCache.resetTagCaches();
    }

    private void addReloadListenersLowest(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this.getRecipeCacheManager());
    }

    private void registerCommands(RegisterCommandsEvent event) {
        BuildCommand.register("boiler", MekanismLang.BOILER, new Builders.BoilerBuilder());
        BuildCommand.register("matrix", MekanismLang.MATRIX, new Builders.MatrixBuilder());
        BuildCommand.register("tank", MekanismLang.DYNAMIC_TANK, new Builders.TankBuilder());
        BuildCommand.register("evaporation", MekanismLang.EVAPORATION_PLANT, new Builders.EvaporationBuilder());
        BuildCommand.register("sps", MekanismLang.SPS, new Builders.SPSBuilder());
        event.getDispatcher().register(CommandMek.register());
    }

    private void serverStopped(ServerStoppedEvent event) {
        playerState.clear(false);
        activeVibrators.clear();
        worldTickHandler.resetChunkData();
        FrequencyType.clear();
        BoilerMultiblockData.hotMap.clear();
        RadiationManager.INSTANCE.reset();
        MultiblockManager.reset();
        FrequencyManager.reset();
        TransporterManager.reset();
        PathfinderCache.reset();
        TransmitterNetworkRegistry.reset();
    }

    private void imcQueue(InterModEnqueueEvent event) {
        hooks.sendIMCMessages(event);
        MekanismIMC.addModulesToAll(MekanismModules.ENERGY_UNIT);
        MekanismIMC.addMekaSuitModules(MekanismModules.LASER_DISSIPATION_UNIT, MekanismModules.RADIATION_SHIELDING_UNIT);
        MekanismIMC.addMekaToolModules(MekanismModules.ATTACK_AMPLIFICATION_UNIT, MekanismModules.SILK_TOUCH_UNIT, MekanismModules.VEIN_MINING_UNIT, MekanismModules.FARMING_UNIT, MekanismModules.SHEARING_UNIT, MekanismModules.TELEPORTATION_UNIT, MekanismModules.EXCAVATION_ESCALATION_UNIT);
        MekanismIMC.addMekaSuitHelmetModules(MekanismModules.ELECTROLYTIC_BREATHING_UNIT, MekanismModules.INHALATION_PURIFICATION_UNIT, MekanismModules.VISION_ENHANCEMENT_UNIT, MekanismModules.NUTRITIONAL_INJECTION_UNIT);
        MekanismIMC.addMekaSuitBodyarmorModules(MekanismModules.JETPACK_UNIT, MekanismModules.GRAVITATIONAL_MODULATING_UNIT, MekanismModules.CHARGE_DISTRIBUTION_UNIT, MekanismModules.DOSIMETER_UNIT, MekanismModules.GEIGER_UNIT, MekanismModules.ELYTRA_UNIT);
        MekanismIMC.addMekaSuitPantsModules(MekanismModules.LOCOMOTIVE_BOOSTING_UNIT);
        MekanismIMC.addMekaSuitBootsModules(MekanismModules.HYDRAULIC_PROPULSION_UNIT, MekanismModules.MAGNETIC_ATTRACTION_UNIT, MekanismModules.FROST_WALKER_UNIT);
    }

    private void imcHandle(InterModProcessEvent event) {
        ModuleHelper.INSTANCE.processIMC();
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IGasHandler.class);
        event.register(IInfusionHandler.class);
        event.register(IPigmentHandler.class);
        event.register(ISlurryHandler.class);
        event.register(IHeatHandler.class);
        event.register(IStrictEnergyHandler.class);
        event.register(IConfigurable.class);
        event.register(IAlloyInteraction.class);
        event.register(IConfigCardAccess.class);
        event.register(IEvaporationSolar.class);
        event.register(ILaserReceptor.class);
        event.register(ILaserDissipation.class);
        event.register(IRadiationShielding.class);
        event.register(IRadiationEntity.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        logger.info("Version {} initializing...", (Object)this.versionNumber);
        hooks.hookCommonSetup();
        this.setRecipeCacheManager(new ReloadListener());
        event.enqueueWork(() -> {
            MekanismTags.init();
            MekAnnotationScanner.collectScanData();
            ForgeChunkManager.setForcedChunkLoadingCallback((String)MODID, (ForgeChunkManager.LoadingValidationCallback)TileComponentChunkLoader.ChunkValidationCallback.INSTANCE);
            MekanismFluids.FLUIDS.registerBucketDispenserBehavior();
            Mekanism.registerDispenseBehavior((DispenseItemBehavior)ItemBlockFluidTank.FluidTankItemDispenseBehavior.INSTANCE, MekanismBlocks.BASIC_FLUID_TANK, MekanismBlocks.ADVANCED_FLUID_TANK, MekanismBlocks.ELITE_FLUID_TANK, MekanismBlocks.ULTIMATE_FLUID_TANK, MekanismBlocks.CREATIVE_FLUID_TANK);
            Mekanism.registerDispenseBehavior((DispenseItemBehavior)new ModuleDispenseBehavior(), MekanismItems.MEKA_TOOL);
            Mekanism.registerDispenseBehavior((DispenseItemBehavior)new MekaSuitDispenseBehavior(), MekanismItems.MEKASUIT_HELMET, MekanismItems.MEKASUIT_BODYARMOR, MekanismItems.MEKASUIT_PANTS, MekanismItems.MEKASUIT_BOOTS);
        });
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)worldTickHandler);
        MinecraftForge.EVENT_BUS.register((Object)RadiationManager.INSTANCE);
        TransmitterNetworkRegistry.initiate();
        this.packetHandler.initialize();
        logger.info("Fake player readout: UUID = {}, name = {}", (Object)gameProfile.getId(), (Object)gameProfile.getName());
        logger.info("Mod loaded.");
    }

    private static void registerDispenseBehavior(DispenseItemBehavior behavior, IItemProvider ... itemProviders) {
        for (IItemProvider itemProvider : itemProviders) {
            DispenserBlock.m_52672_((ItemLike)itemProvider.m_5456_(), (DispenseItemBehavior)behavior);
        }
    }

    private void onEnergyTransferred(EnergyNetwork.EnergyTransferEvent event) {
        this.packetHandler.sendToReceivers(new PacketTransmitterUpdate((EnergyNetwork)event.network), event.network);
    }

    private void onChemicalTransferred(BoxedChemicalNetwork.ChemicalTransferEvent event) {
        this.packetHandler.sendToReceivers(new PacketTransmitterUpdate((BoxedChemicalNetwork)event.network, event.transferType), event.network);
    }

    private void onLiquidTransferred(FluidNetwork.FluidTransferEvent event) {
        this.packetHandler.sendToReceivers(new PacketTransmitterUpdate((FluidNetwork)event.network, event.fluidType), event.network);
    }

    private void onConfigLoad(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            MekanismModConfig mekConfig = (MekanismModConfig)config;
            mekConfig.clearCache();
        }
    }

    private void onWorldLoad(WorldEvent.Load event) {
        playerState.init(event.getWorld());
    }

    private void onWorldUnload(WorldEvent.Unload event) {
        LevelAccessor levelAccessor;
        if (event.getWorld() instanceof ServerLevel) {
            MekFakePlayer.releaseInstance(event.getWorld());
        }
        if ((levelAccessor = event.getWorld()) instanceof Level) {
            Level level = (Level)levelAccessor;
            if (MekanismConfig.general.validOredictionificatorFilters.hasInvalidationListeners()) {
                MekanismConfig.general.validOredictionificatorFilters.removeInvalidationListenersMatching(listener -> {
                    TileEntityOredictionificator.ODConfigValueInvalidationListener odListener;
                    return listener instanceof TileEntityOredictionificator.ODConfigValueInvalidationListener && (odListener = (TileEntityOredictionificator.ODConfigValueInvalidationListener)listener).isIn(level);
                });
            }
        }
    }

    static {
        hooks = new MekanismHooks();
        tankManager = new MultiblockManager("dynamicTank", TankCache::new, TankValidator::new);
        matrixManager = new MultiblockManager("inductionMatrix", MultiblockCache::new, MatrixValidator::new);
        boilerManager = new MultiblockManager("thermoelectricBoiler", MultiblockCache::new, BoilerValidator::new);
        evaporationManager = new MultiblockManager("evaporation", MultiblockCache::new, EvaporationValidator::new);
        spsManager = new MultiblockManager("sps", SPSCache::new, SPSValidator::new);
        tabMekanism = new CreativeTabMekanism();
        modulesLoaded = new ArrayList<IModModule>();
        worldTickHandler = new CommonWorldTickHandler();
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("mekanism.common".getBytes(StandardCharsets.UTF_8)), LOG_TAG);
        keyMap = new KeySync();
        activeVibrators = new ObjectOpenHashSet();
    }
}

