/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.BlockMekanism;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.IStateStorage;
import mekanism.common.item.block.ItemBlockCardboardBox;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockCardboardBox
extends BlockMekanism
implements IStateStorage,
IHasTileEntity<TileEntityCardboardBox> {
    public BlockCardboardBox() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76272_).m_60913_(0.5f, 0.6f));
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        TileEntityCardboardBox box;
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (!BlockCardboardBox.canReplace(world, player, pos, state)) {
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_ && (box = WorldUtils.getTileEntity(TileEntityCardboardBox.class, (BlockGetter)world, pos)) != null && box.storedData != null) {
            BlockData data = box.storedData;
            world.m_46597_(pos, data.blockState);
            if (data.tileTag != null) {
                data.updateLocation(pos);
                BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
                if (tile != null) {
                    tile.m_142466_(data.tileTag);
                }
            }
            BlockCardboardBox.m_49840_((Level)world, (BlockPos)pos, (ItemStack)MekanismBlocks.CARDBOARD_BOX.getItemStack());
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    private static boolean canReplace(Level world, Player player, BlockPos pos, BlockState state) {
        return world.m_7966_(player, pos) && !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, player));
    }

    @Override
    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, HitResult target, @Nonnull BlockGetter world, @Nonnull BlockPos pos, Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        TileEntityCardboardBox tile = WorldUtils.getTileEntity(TileEntityCardboardBox.class, world, pos);
        if (tile == null) {
            return itemStack;
        }
        if (tile.storedData != null) {
            ((ItemBlockCardboardBox)itemStack.m_41720_()).setBlockData(itemStack, tile.storedData);
        }
        return itemStack;
    }

    @Override
    public TileEntityTypeRegistryObject<TileEntityCardboardBox> getTileType() {
        return MekanismTileEntityTypes.CARDBOARD_BOX;
    }

    public static class BlockData {
        @Nonnull
        public final BlockState blockState;
        @Nullable
        public CompoundTag tileTag;

        public BlockData(@Nonnull BlockState blockState) {
            this.blockState = blockState;
        }

        public static BlockData read(CompoundTag nbtTags) {
            BlockData data = new BlockData(NbtUtils.m_129241_((CompoundTag)nbtTags.m_128469_("blockState")));
            NBTUtils.setCompoundIfPresent(nbtTags, "tileTag", nbt -> {
                data.tileTag = nbt;
            });
            return data;
        }

        public void updateLocation(BlockPos pos) {
            if (this.tileTag != null) {
                this.tileTag.m_128405_("x", pos.m_123341_());
                this.tileTag.m_128405_("y", pos.m_123342_());
                this.tileTag.m_128405_("z", pos.m_123343_());
            }
        }

        public CompoundTag write(CompoundTag nbtTags) {
            nbtTags.m_128365_("blockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
            if (this.tileTag != null) {
                nbtTags.m_128365_("tileTag", (Tag)this.tileTag);
            }
            return nbtTags;
        }
    }
}

