/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.client.render.RenderPropertiesProvider;
import mekanism.common.Mekanism;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeHasBounding;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IHasTileEntity;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.lib.security.ISecurityItem;
import mekanism.common.network.to_client.PacketSecurityUpdate;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IComparatorSupport;
import mekanism.common.tile.interfaces.IRedstoneControl;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ISustainedInventory;
import mekanism.common.tile.interfaces.ITileRadioactive;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.IBlockRenderProperties;

public abstract class BlockMekanism
extends Block {
    protected BlockMekanism(BlockBehaviour.Properties properties) {
        super(BlockStateHelper.applyLightLevelAdjustments(properties));
        this.m_49959_(BlockStateHelper.getDefaultState((BlockState)this.f_49792_.m_61090_()));
    }

    public void initializeClient(Consumer<IBlockRenderProperties> consumer) {
        consumer.accept(RenderPropertiesProvider.particles());
    }

    @Nonnull
    @Deprecated
    public PushReaction m_5537_(@Nonnull BlockState state) {
        if (state.m_155947_()) {
            return PushReaction.BLOCK;
        }
        return super.m_5537_(state);
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, HitResult target, @Nonnull BlockGetter world, @Nonnull BlockPos pos, Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        TileEntityMekanism tile = WorldUtils.getTileEntity(TileEntityMekanism.class, world, pos);
        if (tile == null) {
            return itemStack;
        }
        Item item = itemStack.m_41720_();
        if (tile.getFrequencyComponent().hasCustomFrequencies()) {
            tile.getFrequencyComponent().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (item instanceof ISecurityItem) {
            ISecurityItem securityItem = (ISecurityItem)item;
            if (tile.hasSecurity()) {
                securityItem.setOwnerUUID(itemStack, tile.getOwnerUUID());
                securityItem.setSecurity(itemStack, tile.getSecurityMode());
            }
        }
        if (tile.supportsUpgrades()) {
            tile.getComponent().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tile instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)tile);
            config.getConfig().write(ItemDataUtils.getDataMap(itemStack));
            config.getEjector().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tile instanceof ISustainedData) {
            SubstanceType[] sustainedData = (SubstanceType[])tile;
            sustainedData.writeSustainedData(itemStack);
        }
        if (tile.supportsRedstone()) {
            ItemDataUtils.setInt(itemStack, "controlType", tile.getControlType().ordinal());
        }
        for (SubstanceType type : EnumUtils.SUBSTANCES) {
            if (!tile.handles(type)) continue;
            ItemDataUtils.setList(itemStack, type.getContainerTag(), DataHandlerUtils.writeContainers(type.getContainers(tile)));
        }
        if (item instanceof ISustainedInventory) {
            ISustainedInventory sustainedInventory = (ISustainedInventory)item;
            if (tile.persistInventory() && tile.getSlots() > 0) {
                sustainedInventory.setInventory(tile.getInventory(new Object[0]), itemStack);
            }
        }
        return itemStack;
    }

    @Nonnull
    @Deprecated
    public List<ItemStack> m_7381_(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        TileEntityChemicalTank chemicalTank;
        TileEntityMekanism mekTile;
        IHasTileEntity hasTileEntity;
        Object tile;
        List drops = super.m_7381_(state, builder);
        Block block = state.m_60734_();
        if (block instanceof IHasTileEntity && (tile = (hasTileEntity = (IHasTileEntity)block).createDummyBlockEntity(state)) instanceof TileEntityMekanism && !(mekTile = (TileEntityMekanism)tile).getGasTanks(null).isEmpty() && (!(mekTile instanceof TileEntityChemicalTank) || (chemicalTank = (TileEntityChemicalTank)mekTile).getTier() != ChemicalTankTier.CREATIVE)) {
            for (ItemStack drop : drops) {
                ListTag gasTankList = ItemDataUtils.getList(drop, "GasTanks");
                if (gasTankList.isEmpty()) continue;
                int count = DataHandlerUtils.getMaxId(gasTankList, "Tank");
                ArrayList<IGasTank> tanks = new ArrayList<IGasTank>(count);
                for (int i = 0; i < count; ++i) {
                    tanks.add(ChemicalTankBuilder.GAS.createDummy(Long.MAX_VALUE));
                }
                DataHandlerUtils.readContainers(tanks, gasTankList);
                boolean hasRadioactive = false;
                for (IGasTank tank : tanks) {
                    if (tank.isEmpty() || !((GasStack)tank.getStack()).has(GasAttributes.Radiation.class)) continue;
                    hasRadioactive = true;
                    tank.setEmpty();
                }
                if (!hasRadioactive) continue;
                ListTag newGasTankList = DataHandlerUtils.writeContainers(tanks);
                if (newGasTankList.isEmpty()) {
                    ItemDataUtils.removeData(drop, "GasTanks");
                    continue;
                }
                ItemDataUtils.setList(drop, "GasTanks", newGasTankList);
            }
        }
        return drops;
    }

    @Deprecated
    public boolean m_8133_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, int id, int param) {
        boolean triggered = super.m_8133_(state, level, pos, id, param);
        BlockMekanism blockMekanism = this;
        if (blockMekanism instanceof IHasTileEntity) {
            IHasTileEntity hasTileEntity = (IHasTileEntity)((Object)blockMekanism);
            return hasTileEntity.triggerBlockEntityEvent(state, level, pos, id, param);
        }
        return triggered;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        BlockStateHelper.fillBlockStateContainer(this, builder);
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return BlockStateHelper.getStateForPlacement(this, super.m_5573_(context), context);
    }

    @Nonnull
    @Deprecated
    public FluidState m_5888_(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            return fluidLoggable.getFluid(state);
        }
        return super.m_5888_(state);
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        Block block = state.m_60734_();
        if (block instanceof IStateFluidLoggable) {
            IStateFluidLoggable fluidLoggable = (IStateFluidLoggable)block;
            fluidLoggable.updateFluids(state, world, currentPos);
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    @Deprecated
    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        TileEntityMekanism tile;
        AttributeHasBounding hasBounding;
        if (!state.m_60713_(newState.m_60734_()) && (hasBounding = Attribute.get(state, AttributeHasBounding.class)) != null) {
            hasBounding.removeBoundingBlocks(world, pos, state);
        }
        if (!world.f_46443_ && MekanismAPI.getRadiationManager().isRadiationEnabled() && state.m_155947_() && (!state.m_60713_(newState.m_60734_()) || !newState.m_155947_()) && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, pos)) != null && tile.shouldDumpRadiation()) {
            MekanismAPI.getRadiationManager().dumpRadiation(tile.getTileCoord(), tile.getGasTanks(null), false);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntityMekanism tile;
        super.m_6402_(world, pos, state, placer, stack);
        AttributeHasBounding hasBounding = Attribute.get(state, AttributeHasBounding.class);
        if (hasBounding != null) {
            hasBounding.placeBoundingBlocks(world, pos, state);
        }
        if ((tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, pos)) == null) {
            return;
        }
        if (tile.supportsRedstone()) {
            tile.redstone = world.m_46753_(pos);
        }
        if (tile.isNameable() && stack.m_41788_()) {
            tile.setCustomName(stack.m_41786_());
        }
        Item item = stack.m_41720_();
        this.setTileData(world, pos, state, placer, stack, tile);
        if (!world.f_46443_ && tile.getFrequencyComponent().hasCustomFrequencies()) {
            tile.getFrequencyComponent().read(ItemDataUtils.getDataMap(stack));
        }
        if (tile instanceof TileEntitySecurityDesk && placer != null) {
            tile.getSecurity().setOwnerUUID(placer.m_142081_());
        }
        if (item instanceof ISecurityItem) {
            ISecurityItem securityItem = (ISecurityItem)item;
            if (tile.hasSecurity()) {
                tile.setSecurityMode(securityItem.getSecurity(stack));
                UUID ownerUUID = securityItem.getOwnerUUID(stack);
                if (ownerUUID != null) {
                    tile.getSecurity().setOwnerUUID(ownerUUID);
                } else if (placer != null) {
                    tile.getSecurity().setOwnerUUID(placer.m_142081_());
                    if (!world.f_46443_) {
                        Mekanism.packetHandler().sendToAll(new PacketSecurityUpdate(placer.m_142081_(), null));
                    }
                }
            }
        }
        if (tile.supportsUpgrades()) {
            tile.getComponent().read(ItemDataUtils.getDataMap(stack));
        }
        if (tile instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)tile);
            config.getConfig().read(ItemDataUtils.getDataMap(stack));
            config.getEjector().read(ItemDataUtils.getDataMap(stack));
        }
        for (SubstanceType type : EnumUtils.SUBSTANCES) {
            if (!type.canHandle(tile)) continue;
            DataHandlerUtils.readContainers(type.getContainers(tile), ItemDataUtils.getList(stack, type.getContainerTag()));
        }
        if (tile instanceof ISustainedData) {
            ISustainedData sustainedData = (ISustainedData)((Object)tile);
            if (stack.m_41782_()) {
                sustainedData.readSustainedData(stack);
            }
        }
        if (tile.supportsRedstone() && ItemDataUtils.hasData(stack, "controlType", 3)) {
            tile.setControlType(IRedstoneControl.RedstoneControl.byIndexStatic(ItemDataUtils.getInt(stack, "controlType")));
        }
        if (item instanceof ISustainedInventory) {
            ISustainedInventory sustainedInventory = (ISustainedInventory)item;
            if (tile.persistInventory()) {
                tile.setInventory(sustainedInventory.getInventory(stack), new Object[0]);
            }
        }
    }

    public void setTileData(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack, TileEntityMekanism tile) {
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return AttributeStateFacing.rotate(state, world, pos, rotation);
    }

    @Nonnull
    @Deprecated
    public BlockState m_6843_(@Nonnull BlockState state, @Nonnull Rotation rotation) {
        return AttributeStateFacing.rotate(state, rotation);
    }

    @Nonnull
    @Deprecated
    public BlockState m_6943_(@Nonnull BlockState state, @Nonnull Mirror mirror) {
        return AttributeStateFacing.mirror(state, mirror);
    }

    @Deprecated
    public void m_6807_(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        TileEntityMekanism tile;
        if (state.m_155947_() && oldState.m_60734_() != state.m_60734_() && (tile = WorldUtils.getTileEntity(TileEntityMekanism.class, (BlockGetter)world, pos)) != null) {
            tile.onAdded();
        }
        super.m_6807_(state, world, pos, oldState, isMoving);
    }

    @Deprecated
    public boolean m_7278_(@Nonnull BlockState blockState) {
        return Attribute.has(this, Attributes.AttributeComparator.class);
    }

    @Deprecated
    public int m_6782_(@Nonnull BlockState blockState, @Nonnull Level world, @Nonnull BlockPos pos) {
        IComparatorSupport comparatorTile;
        BlockEntity tile;
        if (this.m_7278_(blockState) && (tile = WorldUtils.getTileEntity((BlockGetter)world, pos)) instanceof IComparatorSupport && (comparatorTile = (IComparatorSupport)tile).supportsComparator()) {
            return comparatorTile.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Deprecated
    public float m_5880_(@Nonnull BlockState state, @Nonnull Player player, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return this.getDestroyProgress(state, player, world, pos, state.m_155947_() ? WorldUtils.getTileEntity(world, pos) : null);
    }

    protected float getDestroyProgress(@Nonnull BlockState state, @Nonnull Player player, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nullable BlockEntity tile) {
        ITileRadioactive radioactiveTile;
        float speed = super.m_5880_(state, player, world, pos);
        if (tile instanceof ITileRadioactive && (radioactiveTile = (ITileRadioactive)tile).getRadiationScale() > 0.0f) {
            return speed / 5.0f;
        }
        return speed;
    }

    public void m_7100_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Random random) {
        ITileRadioactive radioactiveTile;
        int count;
        super.m_7100_(state, world, pos, random);
        BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
        if (tile instanceof ITileRadioactive && (count = (radioactiveTile = (ITileRadioactive)tile).getRadiationParticleCount()) > 0) {
            count = random.nextInt(count);
            for (int i = 0; i < count; ++i) {
                double randX = (double)pos.m_123341_() - 0.1 + random.nextDouble() * 1.2;
                double randY = (double)pos.m_123342_() - 0.1 + random.nextDouble() * 1.2;
                double randZ = (double)pos.m_123343_() - 0.1 + random.nextDouble() * 1.2;
                world.m_7106_((ParticleOptions)MekanismParticleTypes.RADIATION.get(), randX, randY, randZ, 0.0, 0.0, 0.0);
            }
        }
    }

    protected InteractionResult genericClientActivated(@Nonnull Player player, @Nonnull InteractionHand hand) {
        if (Attribute.has(this, AttributeGui.class) || MekanismUtils.canUseAsWrench(player.m_21120_(hand))) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

