/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockLogisticalSorter
extends BlockTile.BlockTileModel<TileEntityLogisticalSorter, Machine<TileEntityLogisticalSorter>> {
    public BlockLogisticalSorter() {
        super(MekanismBlockTypes.LOGISTICAL_SORTER);
    }

    @Override
    public void setTileData(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack, @Nonnull TileEntityMekanism tile) {
        TileEntityLogisticalSorter sorter;
        if (tile instanceof TileEntityLogisticalSorter && !(sorter = (TileEntityLogisticalSorter)tile).hasConnectedInventory()) {
            BlockPos tilePos = tile.m_58899_();
            for (Direction dir : EnumUtils.DIRECTIONS) {
                BlockEntity tileEntity = WorldUtils.getTileEntity((BlockGetter)world, tilePos.m_142300_(dir));
                if (!InventoryUtils.isItemHandler(tileEntity, dir)) continue;
                sorter.setFacing(dir.m_122424_());
                break;
            }
        }
    }

    @Override
    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        TileEntityLogisticalSorter tile = WorldUtils.getTileEntity(TileEntityLogisticalSorter.class, (BlockGetter)world, pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return this.genericClientActivated(player, hand);
        }
        ItemStack stack = player.m_21120_(hand);
        if (MekanismUtils.canUseAsWrench(stack)) {
            if (SecurityUtils.canAccess(player, tile)) {
                if (player.m_6144_()) {
                    WorldUtils.dismantleBlock(state, world, pos);
                    return InteractionResult.SUCCESS;
                }
                Direction change = tile.getDirection().m_122427_();
                if (!tile.hasConnectedInventory()) {
                    for (Direction dir : EnumUtils.DIRECTIONS) {
                        BlockEntity tileEntity = WorldUtils.getTileEntity((BlockGetter)world, pos.m_142300_(dir));
                        if (!InventoryUtils.isItemHandler(tileEntity, dir)) continue;
                        change = dir.m_122424_();
                        break;
                    }
                }
                tile.setFacing(change);
                world.m_46672_(pos, (Block)this);
                return InteractionResult.SUCCESS;
            }
            SecurityUtils.displayNoAccess(player);
            return InteractionResult.FAIL;
        }
        return tile.openGui(player);
    }

    @Override
    @Nonnull
    @Deprecated
    public BlockState m_7417_(BlockState state, @Nonnull Direction dir, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos neighborPos) {
        BlockEntity tileEntity;
        TileEntityLogisticalSorter sorter;
        if (!world.m_5776_() && (sorter = WorldUtils.getTileEntity(TileEntityLogisticalSorter.class, (BlockGetter)world, pos)) != null && !sorter.hasConnectedInventory() && InventoryUtils.isItemHandler(tileEntity = WorldUtils.getTileEntity((BlockGetter)world, neighborPos), dir)) {
            sorter.setFacing(dir.m_122424_());
            state = sorter.m_58900_();
        }
        return super.m_7417_(state, dir, facingState, world, pos, neighborPos);
    }
}

