/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.DataHandlerUtils;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ItemStackMekanismChemicalHandler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>>
extends ItemCapabilityWrapper.ItemCapability
implements IMekanismChemicalHandler<CHEMICAL, STACK, TANK> {
    protected List<TANK> tanks;

    @Override
    protected void init() {
        this.tanks = this.getInitialTanks();
    }

    @Override
    protected void load() {
        ItemStack stack = this.getStack();
        if (!stack.m_41619_()) {
            DataHandlerUtils.readContainers(this.getChemicalTanks(null), ItemDataUtils.getList(stack, this.getNbtKey()));
        }
    }

    @Override
    public void onContentsChanged() {
        ItemStack stack = this.getStack();
        if (!stack.m_41619_()) {
            ItemDataUtils.setList(stack, this.getNbtKey(), DataHandlerUtils.writeContainers(this.getChemicalTanks(null)));
        }
    }

    @Override
    @Nonnull
    public List<TANK> getChemicalTanks(@Nullable Direction side) {
        return this.tanks;
    }

    protected abstract List<TANK> getInitialTanks();

    protected abstract String getNbtKey();
}

