/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.heat;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.common.capabilities.holder.heat.ConfigHeatCapacitorHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHolder;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.core.Direction;

public class HeatCapacitorHelper {
    private final IHeatCapacitorHolder slotHolder;
    private boolean built;

    private HeatCapacitorHelper(IHeatCapacitorHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static HeatCapacitorHelper forSide(Supplier<Direction> facingSupplier) {
        return new HeatCapacitorHelper(new HeatCapacitorHolder(facingSupplier));
    }

    public static HeatCapacitorHelper forSideWithConfig(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        return new HeatCapacitorHelper(new ConfigHeatCapacitorHolder(facingSupplier, configSupplier));
    }

    public <CAPACITOR extends IHeatCapacitor> CAPACITOR addCapacitor(@Nonnull CAPACITOR capacitor) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IHeatCapacitorHolder iHeatCapacitorHolder = this.slotHolder;
        if (iHeatCapacitorHolder instanceof HeatCapacitorHolder) {
            HeatCapacitorHolder slotHolder = (HeatCapacitorHolder)iHeatCapacitorHolder;
            slotHolder.addCapacitor(capacitor, new RelativeSide[0]);
        } else {
            iHeatCapacitorHolder = this.slotHolder;
            if (iHeatCapacitorHolder instanceof ConfigHeatCapacitorHolder) {
                ConfigHeatCapacitorHolder slotHolder = (ConfigHeatCapacitorHolder)iHeatCapacitorHolder;
                slotHolder.addCapacitor(capacitor);
            } else {
                throw new IllegalArgumentException("Holder does not know how to add capacitors");
            }
        }
        return capacitor;
    }

    public <CAPACITOR extends IHeatCapacitor> CAPACITOR addCapacitor(@Nonnull CAPACITOR capacitor, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IHeatCapacitorHolder iHeatCapacitorHolder = this.slotHolder;
        if (!(iHeatCapacitorHolder instanceof HeatCapacitorHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add capacitors on specific sides");
        }
        HeatCapacitorHolder slotHolder = (HeatCapacitorHolder)iHeatCapacitorHolder;
        slotHolder.addCapacitor(capacitor, sides);
        return capacitor;
    }

    public IHeatCapacitorHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

